/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.runtime.writer;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.api.component.runtime.Result;
import org.talend.components.api.component.runtime.WriteOperation;
import org.talend.components.api.component.runtime.Writer;
import org.talend.components.api.container.RuntimeContainer;
import org.talend.components.jdbc.CommonUtils;
import org.talend.components.jdbc.runtime.JDBCRollbackSink;

public class JDBCRollbackWriter
implements Writer<Result> {
    private static final transient Logger LOG = LoggerFactory.getLogger(JDBCRollbackWriter.class);
    private WriteOperation<Result> writeOperation;
    private JDBCRollbackSink sink;
    private Result result;
    private RuntimeContainer runtime;

    public JDBCRollbackWriter(WriteOperation<Result> writeOperation, RuntimeContainer runtime) {
        this.writeOperation = writeOperation;
        this.sink = (JDBCRollbackSink)writeOperation.getSink();
        this.runtime = runtime;
        this.result = new Result();
    }

    public void open(String uId) throws IOException {
    }

    public void write(Object datum) throws IOException {
        ++this.result.totalCount;
        try {
            this.sink.doRollbackAction(this.runtime);
        }
        catch (Exception e) {
            throw CommonUtils.newComponentException((Throwable)e);
        }
    }

    public Result close() throws IOException {
        return this.result;
    }

    public WriteOperation<Result> getWriteOperation() {
        return this.writeOperation;
    }
}

