/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.runtime.writer;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.api.component.runtime.Result;
import org.talend.components.api.component.runtime.WriteOperation;
import org.talend.components.api.container.RuntimeContainer;
import org.talend.components.jdbc.CommonUtils;
import org.talend.components.jdbc.runtime.setting.JDBCSQLBuilder;
import org.talend.components.jdbc.runtime.type.RowWriter;
import org.talend.components.jdbc.runtime.writer.JDBCOutputWriter;

public class JDBCOutputUpdateWriter
extends JDBCOutputWriter {
    private static final transient Logger LOG = LoggerFactory.getLogger(JDBCOutputUpdateWriter.class);
    private String sql;
    private RowWriter rowWriter = null;

    public JDBCOutputUpdateWriter(WriteOperation<Result> writeOperation, RuntimeContainer runtime) {
        super(writeOperation, runtime);
    }

    @Override
    public void open(String uId) throws IOException {
        super.open(uId);
        try {
            this.conn = this.sink.getConnection(this.runtime);
            this.sql = JDBCSQLBuilder.getInstance().generateSQL4Update(this.setting.getTablename(), this.columnList);
            this.statement = this.conn.prepareStatement(this.sql);
        }
        catch (ClassNotFoundException | SQLException e) {
            throw CommonUtils.newComponentException((Throwable)e);
        }
    }

    private void initRowWriterIfNot(List<JDBCSQLBuilder.Column> columnList, Schema inputSchema, Schema componentSchema) {
        if (this.rowWriter == null) {
            ArrayList<JDBCSQLBuilder.Column> columnList4Statement = new ArrayList<JDBCSQLBuilder.Column>();
            for (JDBCSQLBuilder.Column column : columnList) {
                if (column.addCol || column.isReplaced() || !column.updatable) continue;
                columnList4Statement.add(column);
            }
            for (JDBCSQLBuilder.Column column : columnList) {
                if (column.addCol || column.isReplaced() || !column.updateKey) continue;
                columnList4Statement.add(column);
            }
            this.rowWriter = new RowWriter(columnList4Statement, inputSchema, componentSchema, this.statement, this.setting.getDebug(), this.sql);
        }
    }

    @Override
    public void write(Object datum) throws IOException {
        super.write(datum);
        IndexedRecord input = (IndexedRecord)this.getFactory(datum).convertToAvro(datum);
        Schema inputSchema = input.getSchema();
        this.initRowWriterIfNot(this.columnList, inputSchema, this.componentSchema);
        try {
            String sql_fact = this.rowWriter.write(input);
            if (sql_fact != null) {
                this.runtime.setComponentData(this.runtime.getCurrentComponentId(), QUERY_KEY, (Object)sql_fact);
            }
            if (this.setting.getDebug()) {
                LOG.debug("'" + sql_fact.trim() + "'.");
            }
        }
        catch (SQLException e) {
            throw CommonUtils.newComponentException((Throwable)e);
        }
        try {
            this.updateCount += this.execute(input, this.statement);
        }
        catch (SQLException e) {
            if (this.dieOnError) {
                throw CommonUtils.newComponentException((Throwable)e);
            }
            System.err.println(e.getMessage());
            LOG.warn(e.getMessage());
            this.handleReject(input, e);
        }
        try {
            this.updateCount += this.executeCommit(this.statement);
        }
        catch (SQLException e) {
            if (this.dieOnError) {
                throw CommonUtils.newComponentException((Throwable)e);
            }
            LOG.warn(e.getMessage());
        }
    }

    @Override
    public Result close() throws IOException {
        this.updateCount += this.executeBatchAtLast();
        this.closeStatementQuietly(this.statement);
        this.statement = null;
        this.commitAndCloseAtLast();
        this.constructResult();
        return this.result;
    }
}

