/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.runtime.writer;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.api.component.runtime.Result;
import org.talend.components.api.component.runtime.WriteOperation;
import org.talend.components.api.container.RuntimeContainer;
import org.talend.components.jdbc.CommonUtils;
import org.talend.components.jdbc.runtime.setting.JDBCSQLBuilder;
import org.talend.components.jdbc.runtime.type.RowWriter;
import org.talend.components.jdbc.runtime.writer.JDBCOutputWriter;

public class JDBCOutputUpdateOrInsertWriter
extends JDBCOutputWriter {
    private static final transient Logger LOG = LoggerFactory.getLogger(JDBCOutputUpdateOrInsertWriter.class);
    private String sqlInsert;
    private String sqlUpdate;
    private PreparedStatement statementInsert;
    private PreparedStatement statementUpdate;
    private RowWriter rowWriter4Update = null;
    private RowWriter rowWriter4Insert = null;

    public JDBCOutputUpdateOrInsertWriter(WriteOperation<Result> writeOperation, RuntimeContainer runtime) {
        super(writeOperation, runtime);
    }

    @Override
    public void open(String uId) throws IOException {
        super.open(uId);
        try {
            this.conn = this.sink.getConnection(this.runtime);
            this.sqlInsert = JDBCSQLBuilder.getInstance().generateSQL4Insert(this.setting.getTablename(), this.columnList);
            this.statementInsert = this.conn.prepareStatement(this.sqlInsert);
            this.sqlUpdate = JDBCSQLBuilder.getInstance().generateSQL4Update(this.setting.getTablename(), this.columnList);
            this.statementUpdate = this.conn.prepareStatement(this.sqlUpdate);
        }
        catch (ClassNotFoundException | SQLException e) {
            throw CommonUtils.newComponentException((Throwable)e);
        }
    }

    private void initRowWriterIfNot(List<JDBCSQLBuilder.Column> columnList, Schema inputSchema, Schema componentSchema) {
        ArrayList<JDBCSQLBuilder.Column> columnList4Statement;
        if (this.rowWriter4Update == null) {
            columnList4Statement = new ArrayList<JDBCSQLBuilder.Column>();
            for (JDBCSQLBuilder.Column column : columnList) {
                if (column.addCol || column.isReplaced() || !column.updatable) continue;
                columnList4Statement.add(column);
            }
            for (JDBCSQLBuilder.Column column : columnList) {
                if (column.addCol || column.isReplaced() || !column.updateKey) continue;
                columnList4Statement.add(column);
            }
            this.rowWriter4Update = new RowWriter(columnList4Statement, inputSchema, componentSchema, this.statementUpdate, this.setting.getDebug(), this.sqlUpdate);
        }
        if (this.rowWriter4Insert == null) {
            columnList4Statement = new ArrayList();
            for (JDBCSQLBuilder.Column column : columnList) {
                if (column.addCol || column.isReplaced() || !column.insertable) continue;
                columnList4Statement.add(column);
            }
            this.rowWriter4Insert = new RowWriter(columnList4Statement, inputSchema, componentSchema, this.statementInsert, this.setting.getDebug(), this.sqlInsert);
        }
    }

    @Override
    public void write(Object datum) throws IOException {
        super.write(datum);
        IndexedRecord input = (IndexedRecord)this.getFactory(datum).convertToAvro(datum);
        Schema inputSchema = input.getSchema();
        this.initRowWriterIfNot(this.columnList, inputSchema, this.componentSchema);
        try {
            String updateSql_fact = this.rowWriter4Update.write(input);
            if (updateSql_fact != null) {
                this.runtime.setComponentData(this.runtime.getCurrentComponentId(), QUERY_KEY, (Object)updateSql_fact);
            }
            if (this.setting.getDebug()) {
                LOG.debug("'" + updateSql_fact.trim() + "'.");
            }
        }
        catch (SQLException e) {
            throw CommonUtils.newComponentException((Throwable)e);
        }
        try {
            boolean noDataUpdate;
            int count = this.statementUpdate.executeUpdate();
            this.updateCount += count;
            boolean bl = noDataUpdate = count == 0;
            if (noDataUpdate) {
                String insertSql_fact = this.rowWriter4Insert.write(input);
                if (insertSql_fact != null) {
                    this.runtime.setComponentData(this.runtime.getCurrentComponentId(), QUERY_KEY, (Object)insertSql_fact);
                }
                if (this.setting.getDebug()) {
                    LOG.debug("'" + insertSql_fact.trim() + "'.");
                }
                this.insertCount += this.execute(input, this.statementInsert);
            } else {
                ++this.result.totalCount;
                this.handleSuccess(input);
            }
        }
        catch (SQLException e) {
            if (this.dieOnError) {
                throw CommonUtils.newComponentException((Throwable)e);
            }
            ++this.result.totalCount;
            System.err.println(e.getMessage());
            LOG.warn(e.getMessage());
            this.handleReject(input, e);
        }
        try {
            this.executeCommit(null);
        }
        catch (SQLException e) {
            if (this.dieOnError) {
                throw CommonUtils.newComponentException((Throwable)e);
            }
            LOG.warn(e.getMessage());
        }
    }

    @Override
    public Result close() throws IOException {
        this.closeStatementQuietly(this.statementUpdate);
        this.closeStatementQuietly(this.statementInsert);
        this.statementUpdate = null;
        this.statementInsert = null;
        this.commitAndCloseAtLast();
        this.constructResult();
        return this.result;
    }
}

