/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.runtime.type;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.talend.components.jdbc.CommonUtils;
import org.talend.components.jdbc.runtime.setting.JDBCSQLBuilder;
import org.talend.components.jdbc.runtime.type.DebugUtil;
import org.talend.daikon.avro.AvroUtils;

public class RowWriter {
    private TypeWriter[] typeWriters;
    private final boolean debug;
    private DebugUtil debugUtil;

    public RowWriter(List<JDBCSQLBuilder.Column> columnList, Schema inputSchema, Schema componentSchema, PreparedStatement statement) {
        this(columnList, inputSchema, componentSchema, statement, false, null);
    }

    public RowWriter(List<JDBCSQLBuilder.Column> columnList, Schema inputSchema, Schema componentSchema, PreparedStatement statement, boolean debug, String sql) {
        this.debug = debug;
        if (debug) {
            this.debugUtil = new DebugUtil(sql);
        }
        ArrayList<StringTypeWriter> writers = new ArrayList<StringTypeWriter>();
        int statementIndex = 0;
        for (JDBCSQLBuilder.Column column : columnList) {
            Schema.Field inputField = CommonUtils.getField((Schema)inputSchema, (String)column.columnLabel);
            Schema.Field componentField = CommonUtils.getField((Schema)componentSchema, (String)column.columnLabel);
            int inputValueLocation = inputField.pos();
            String pattern = componentField.getProp("talend.field.pattern");
            Schema basicSchema = AvroUtils.unwrapIfNullable((Schema)componentField.schema());
            TypeWriter writer = null;
            writer = AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._string()) ? new StringTypeWriter(statement, statementIndex, inputValueLocation) : (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._int()) ? new IntTypeWriter(statement, statementIndex, inputValueLocation) : (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._date()) ? new DateTypeWriter(statement, statementIndex, inputValueLocation, pattern) : (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._decimal()) ? new BigDecimalTypeWriter(statement, statementIndex, inputValueLocation) : (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._long()) ? new LongTypeWriter(statement, statementIndex, inputValueLocation) : (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._double()) ? new DoubleTypeWriter(statement, statementIndex, inputValueLocation) : (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._float()) ? new FloatTypeWriter(statement, statementIndex, inputValueLocation) : (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._boolean()) ? new BooleanTypeWriter(statement, statementIndex, inputValueLocation) : (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._short()) ? new ShortTypeWriter(statement, statementIndex, inputValueLocation) : (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._character()) ? new CharacterTypeWriter(statement, statementIndex, inputValueLocation) : (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._byte()) ? new ByteTypeWriter(statement, statementIndex, inputValueLocation) : (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._bytes()) ? new BytesTypeWriter(statement, statementIndex, inputValueLocation) : new ObjectTypeWriter(statement, ++statementIndex, inputValueLocation))))))))))));
            writers.add((StringTypeWriter)writer);
        }
        this.typeWriters = writers.toArray(new TypeWriter[0]);
    }

    public String write(IndexedRecord input) throws SQLException {
        if (this.debug) {
            this.debugUtil.writeHead();
        }
        for (TypeWriter writer : this.typeWriters) {
            writer.write(input);
        }
        if (this.debug) {
            return this.debugUtil.getSQL();
        }
        return null;
    }

    private void writeDebugColumnNullContent() {
        if (this.debug) {
            this.debugUtil.writeColumn(null, false);
        }
    }

    class ObjectTypeWriter
    extends TypeWriter {
        ObjectTypeWriter(PreparedStatement statement, int statementIndex, int inputValueLocation) {
            super(statement, statementIndex, inputValueLocation);
        }

        @Override
        public void write(IndexedRecord input) throws SQLException {
            Object inputValue = input.get(this.inputValueLocation);
            if (inputValue == null) {
                this.statement.setNull(this.statementIndex, 2000);
                RowWriter.this.writeDebugColumnNullContent();
            } else {
                this.statement.setObject(this.statementIndex, inputValue);
                if (RowWriter.this.debug) {
                    RowWriter.this.debugUtil.writeColumn(inputValue.toString(), false);
                }
            }
        }
    }

    class BytesTypeWriter
    extends TypeWriter {
        BytesTypeWriter(PreparedStatement statement, int statementIndex, int inputValueLocation) {
            super(statement, statementIndex, inputValueLocation);
        }

        @Override
        public void write(IndexedRecord input) throws SQLException {
            Object inputValue = input.get(this.inputValueLocation);
            if (inputValue == null) {
                this.statement.setNull(this.statementIndex, 2003);
                RowWriter.this.writeDebugColumnNullContent();
            } else {
                this.statement.setBytes(this.statementIndex, (byte[])inputValue);
                if (RowWriter.this.debug) {
                    RowWriter.this.debugUtil.writeColumn(inputValue.toString(), false);
                }
            }
        }
    }

    class CharacterTypeWriter
    extends TypeWriter {
        CharacterTypeWriter(PreparedStatement statement, int statementIndex, int inputValueLocation) {
            super(statement, statementIndex, inputValueLocation);
        }

        @Override
        public void write(IndexedRecord input) throws SQLException {
            Object inputValue = input.get(this.inputValueLocation);
            if (inputValue == null) {
                this.statement.setNull(this.statementIndex, 1);
                RowWriter.this.writeDebugColumnNullContent();
            } else {
                this.statement.setInt(this.statementIndex, ((Character)inputValue).charValue());
                if (RowWriter.this.debug) {
                    RowWriter.this.debugUtil.writeColumn(inputValue.toString(), true);
                }
            }
        }
    }

    class ByteTypeWriter
    extends TypeWriter {
        ByteTypeWriter(PreparedStatement statement, int statementIndex, int inputValueLocation) {
            super(statement, statementIndex, inputValueLocation);
        }

        @Override
        public void write(IndexedRecord input) throws SQLException {
            Object inputValue = input.get(this.inputValueLocation);
            if (inputValue == null) {
                this.statement.setNull(this.statementIndex, 4);
                RowWriter.this.writeDebugColumnNullContent();
            } else {
                this.statement.setByte(this.statementIndex, ((Number)inputValue).byteValue());
                if (RowWriter.this.debug) {
                    RowWriter.this.debugUtil.writeColumn(inputValue.toString(), false);
                }
            }
        }
    }

    class ShortTypeWriter
    extends TypeWriter {
        ShortTypeWriter(PreparedStatement statement, int statementIndex, int inputValueLocation) {
            super(statement, statementIndex, inputValueLocation);
        }

        @Override
        public void write(IndexedRecord input) throws SQLException {
            Object inputValue = input.get(this.inputValueLocation);
            if (inputValue == null) {
                this.statement.setNull(this.statementIndex, 4);
                RowWriter.this.writeDebugColumnNullContent();
            } else {
                this.statement.setShort(this.statementIndex, ((Number)inputValue).shortValue());
                if (RowWriter.this.debug) {
                    RowWriter.this.debugUtil.writeColumn(inputValue.toString(), false);
                }
            }
        }
    }

    class BooleanTypeWriter
    extends TypeWriter {
        BooleanTypeWriter(PreparedStatement statement, int statementIndex, int inputValueLocation) {
            super(statement, statementIndex, inputValueLocation);
        }

        @Override
        public void write(IndexedRecord input) throws SQLException {
            Object inputValue = input.get(this.inputValueLocation);
            if (inputValue == null) {
                this.statement.setNull(this.statementIndex, 16);
                RowWriter.this.writeDebugColumnNullContent();
            } else {
                this.statement.setBoolean(this.statementIndex, (Boolean)inputValue);
                if (RowWriter.this.debug) {
                    RowWriter.this.debugUtil.writeColumn(inputValue.toString(), false);
                }
            }
        }
    }

    class FloatTypeWriter
    extends TypeWriter {
        FloatTypeWriter(PreparedStatement statement, int statementIndex, int inputValueLocation) {
            super(statement, statementIndex, inputValueLocation);
        }

        @Override
        public void write(IndexedRecord input) throws SQLException {
            Object inputValue = input.get(this.inputValueLocation);
            if (inputValue == null) {
                this.statement.setNull(this.statementIndex, 6);
                RowWriter.this.writeDebugColumnNullContent();
            } else {
                this.statement.setFloat(this.statementIndex, ((Float)inputValue).floatValue());
                if (RowWriter.this.debug) {
                    RowWriter.this.debugUtil.writeColumn(inputValue.toString(), false);
                }
            }
        }
    }

    class DoubleTypeWriter
    extends TypeWriter {
        DoubleTypeWriter(PreparedStatement statement, int statementIndex, int inputValueLocation) {
            super(statement, statementIndex, inputValueLocation);
        }

        @Override
        public void write(IndexedRecord input) throws SQLException {
            Object inputValue = input.get(this.inputValueLocation);
            if (inputValue == null) {
                this.statement.setNull(this.statementIndex, 8);
                RowWriter.this.writeDebugColumnNullContent();
            } else {
                this.statement.setDouble(this.statementIndex, (Double)inputValue);
                if (RowWriter.this.debug) {
                    RowWriter.this.debugUtil.writeColumn(inputValue.toString(), false);
                }
            }
        }
    }

    class LongTypeWriter
    extends TypeWriter {
        LongTypeWriter(PreparedStatement statement, int statementIndex, int inputValueLocation) {
            super(statement, statementIndex, inputValueLocation);
        }

        @Override
        public void write(IndexedRecord input) throws SQLException {
            Object inputValue = input.get(this.inputValueLocation);
            if (inputValue == null) {
                this.statement.setNull(this.statementIndex, 4);
                RowWriter.this.writeDebugColumnNullContent();
            } else {
                this.statement.setLong(this.statementIndex, (Long)inputValue);
                if (RowWriter.this.debug) {
                    RowWriter.this.debugUtil.writeColumn(inputValue.toString(), false);
                }
            }
        }
    }

    class BigDecimalTypeWriter
    extends TypeWriter {
        BigDecimalTypeWriter(PreparedStatement statement, int statementIndex, int inputValueLocation) {
            super(statement, statementIndex, inputValueLocation);
        }

        @Override
        public void write(IndexedRecord input) throws SQLException {
            Object inputValue = input.get(this.inputValueLocation);
            if (inputValue == null) {
                this.statement.setNull(this.statementIndex, 3);
                RowWriter.this.writeDebugColumnNullContent();
            } else {
                this.statement.setBigDecimal(this.statementIndex, (BigDecimal)inputValue);
                if (RowWriter.this.debug) {
                    RowWriter.this.debugUtil.writeColumn(inputValue.toString(), false);
                }
            }
        }
    }

    class DateTypeWriter
    extends TypeWriter {
        private String pattern;

        DateTypeWriter(PreparedStatement statement, int statementIndex, int inputValueLocation, String pattern) {
            super(statement, statementIndex, inputValueLocation);
            this.pattern = pattern;
        }

        @Override
        public void write(IndexedRecord input) throws SQLException {
            Object inputValue = input.get(this.inputValueLocation);
            if (inputValue == null) {
                this.statement.setNull(this.statementIndex, 93);
            } else if (inputValue instanceof Date) {
                this.statement.setTimestamp(this.statementIndex, new Timestamp(((Date)inputValue).getTime()));
                if (RowWriter.this.debug) {
                    if (this.pattern.length() == 0 || this.pattern == null) {
                        RowWriter.this.debugUtil.writeColumn(inputValue.toString(), false);
                    } else {
                        SimpleDateFormat sdf = new SimpleDateFormat(this.pattern);
                        RowWriter.this.debugUtil.writeColumn(sdf.format((Date)inputValue), false);
                    }
                }
            } else {
                this.statement.setTimestamp(this.statementIndex, new Timestamp((Long)inputValue));
                if (RowWriter.this.debug) {
                    RowWriter.this.debugUtil.writeColumn(new Timestamp((Long)inputValue).toString(), false);
                }
            }
        }
    }

    class IntTypeWriter
    extends TypeWriter {
        IntTypeWriter(PreparedStatement statement, int statementIndex, int inputValueLocation) {
            super(statement, statementIndex, inputValueLocation);
        }

        @Override
        public void write(IndexedRecord input) throws SQLException {
            Object inputValue = input.get(this.inputValueLocation);
            if (inputValue == null) {
                this.statement.setNull(this.statementIndex, 4);
                RowWriter.this.writeDebugColumnNullContent();
            } else {
                this.statement.setInt(this.statementIndex, (Integer)inputValue);
                if (RowWriter.this.debug) {
                    RowWriter.this.debugUtil.writeColumn(inputValue.toString(), false);
                }
            }
        }
    }

    class StringTypeWriter
    extends TypeWriter {
        StringTypeWriter(PreparedStatement statement, int statementIndex, int inputValueLocation) {
            super(statement, statementIndex, inputValueLocation);
        }

        @Override
        public void write(IndexedRecord input) throws SQLException {
            Object inputValue = input.get(this.inputValueLocation);
            if (inputValue == null) {
                this.statement.setNull(this.statementIndex, 12);
                RowWriter.this.writeDebugColumnNullContent();
            } else {
                this.statement.setString(this.statementIndex, inputValue.toString());
                if (RowWriter.this.debug) {
                    RowWriter.this.debugUtil.writeColumn(inputValue.toString(), true);
                }
            }
        }
    }

    class TypeWriter {
        protected final PreparedStatement statement;
        protected final int statementIndex;
        protected final int inputValueLocation;

        protected TypeWriter(PreparedStatement statement, int statementIndex, int inputValueLocation) {
            this.statement = statement;
            this.statementIndex = statementIndex;
            this.inputValueLocation = inputValueLocation;
        }

        void write(IndexedRecord input) throws SQLException {
        }
    }
}

