/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.runtime.type;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.avro.Schema;
import org.talend.daikon.avro.AvroUtils;

public class JDBCMapping {
    public static void setValue(int index, PreparedStatement statement, Schema.Field f, Object value) throws SQLException {
        Schema basicSchema = AvroUtils.unwrapIfNullable((Schema)f.schema());
        if (value == null) {
            if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._string())) {
                statement.setNull(index, 12);
            } else if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._int())) {
                statement.setNull(index, 4);
            } else if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._date())) {
                statement.setNull(index, 93);
            } else if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._decimal())) {
                statement.setNull(index, 3);
            } else if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._long())) {
                statement.setNull(index, -5);
            } else if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._double())) {
                statement.setNull(index, 8);
            } else if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._float())) {
                statement.setNull(index, 6);
            } else if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._boolean())) {
                statement.setNull(index, 16);
            } else if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._short())) {
                statement.setNull(index, 5);
            } else if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._character())) {
                statement.setNull(index, 1);
            } else if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._byte())) {
                statement.setNull(index, 5);
            } else if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._bytes())) {
                statement.setNull(index, 2003);
            } else {
                statement.setNull(index, 2000);
            }
            return;
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._string())) {
            statement.setString(index, String.valueOf(value));
        } else if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._int())) {
            statement.setInt(index, (Integer)value);
        } else if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._date())) {
            Date date = (Date)value;
            statement.setTimestamp(index, new Timestamp(date.getTime()));
        } else if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._decimal())) {
            statement.setBigDecimal(index, (BigDecimal)value);
        } else if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._long())) {
            statement.setLong(index, (Long)value);
        } else if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._double())) {
            statement.setDouble(index, (Double)value);
        } else if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._float())) {
            statement.setFloat(index, ((Float)value).floatValue());
        } else if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._boolean())) {
            statement.setBoolean(index, (Boolean)value);
        } else if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._short())) {
            statement.setShort(index, (Short)value);
        } else if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._character())) {
            statement.setInt(index, ((Character)value).charValue());
        } else if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._byte())) {
            statement.setByte(index, (Byte)value);
        } else if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._bytes())) {
            statement.setBytes(index, (byte[])value);
        } else {
            statement.setObject(index, value);
        }
    }

    public static int getSQLTypeFromAvroType(Schema.Field f) {
        Schema basicSchema = AvroUtils.unwrapIfNullable((Schema)f.schema());
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._string())) {
            return 12;
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._int())) {
            return 4;
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._date())) {
            return 91;
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._decimal())) {
            return 3;
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._long())) {
            return -5;
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._double())) {
            return 8;
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._float())) {
            return 6;
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._boolean())) {
            return 16;
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._short())) {
            return 5;
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._character())) {
            return 1;
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._byte())) {
            return -6;
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._bytes())) {
            return 1111;
        }
        return 1111;
    }
}

