/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.runtime.schemainfer;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.codehaus.jackson.JsonNode;
import org.talend.components.common.avro.JDBCTableMetadata;
import org.talend.components.common.config.jdbc.Dbms;
import org.talend.components.common.config.jdbc.DbmsType;
import org.talend.components.common.config.jdbc.MappingType;
import org.talend.components.common.config.jdbc.TalendType;
import org.talend.daikon.avro.AvroUtils;
import org.talend.daikon.avro.NameUtil;

public class SchemaInferer {
    public static Schema infer(ResultSetMetaData metadata, Dbms mapping) throws SQLException {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        HashSet<String> existNames = new HashSet<String>();
        int index = 0;
        int count = metadata.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            int size = metadata.getPrecision(i);
            int scale = metadata.getScale(i);
            boolean nullable = 1 == metadata.isNullable(i);
            int dbtype = metadata.getColumnType(i);
            String fieldName = metadata.getColumnLabel(i);
            String dbColumnName = metadata.getColumnName(i);
            boolean isKey = false;
            String columnTypeName = metadata.getColumnTypeName(i).toUpperCase();
            String validName = NameUtil.correct((String)fieldName, (int)index++, existNames);
            existNames.add(validName);
            Schema.Field field = SchemaInferer.sqlType2Avro(size, scale, dbtype, nullable, validName, dbColumnName, null, isKey, mapping, columnTypeName);
            fields.add(field);
        }
        return Schema.createRecord((String)"DYNAMIC", null, null, (boolean)false, fields);
    }

    public static Schema infer(JDBCTableMetadata tableMetadata, Dbms mapping) throws SQLException {
        DatabaseMetaData databaseMetdata = tableMetadata.getDatabaseMetaData();
        Set<String> keys = SchemaInferer.getPrimaryKeys(databaseMetdata, tableMetadata.getCatalog(), tableMetadata.getDbSchema(), tableMetadata.getTablename());
        HashSet<String> existNames = new HashSet<String>();
        int index = 0;
        try (ResultSet metadata = databaseMetdata.getColumns(tableMetadata.getCatalog(), tableMetadata.getDbSchema(), tableMetadata.getTablename(), null);){
            if (!metadata.next()) {
                Schema schema = null;
                return schema;
            }
            ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
            String tablename = metadata.getString("TABLE_NAME");
            do {
                int size = metadata.getInt("COLUMN_SIZE");
                int scale = metadata.getInt("DECIMAL_DIGITS");
                int dbtype = metadata.getInt("DATA_TYPE");
                boolean nullable = 1 == metadata.getInt("NULLABLE");
                String columnName = metadata.getString("COLUMN_NAME");
                boolean isKey = keys.contains(columnName);
                String defaultValue = metadata.getString("COLUMN_DEF");
                String columnTypeName = metadata.getString("TYPE_NAME");
                String validName = NameUtil.correct((String)columnName, (int)index++, existNames);
                existNames.add(validName);
                Schema.Field field = SchemaInferer.sqlType2Avro(size, scale, dbtype, nullable, validName, columnName, defaultValue, isKey, mapping, columnTypeName);
                fields.add(field);
            } while (metadata.next());
            Schema schema = Schema.createRecord((String)NameUtil.correct((String)tablename, (int)0, new HashSet()), null, null, (boolean)false, fields);
            return schema;
        }
    }

    private static Set<String> getPrimaryKeys(DatabaseMetaData databaseMetdata, String catalogName, String schemaName, String tableName) throws SQLException {
        HashSet<String> result = new HashSet<String>();
        try (ResultSet resultSet = databaseMetdata.getPrimaryKeys(catalogName, schemaName, tableName);){
            if (resultSet != null) {
                while (resultSet.next()) {
                    result.add(resultSet.getString("COLUMN_NAME"));
                }
            }
        }
        return result;
    }

    private static Schema convertToAvro(TalendType talendType) {
        switch (talendType) {
            case STRING: {
                return AvroUtils._string();
            }
            case BOOLEAN: {
                return AvroUtils._boolean();
            }
            case INTEGER: {
                return AvroUtils._int();
            }
            case LONG: {
                return AvroUtils._long();
            }
            case DOUBLE: {
                return AvroUtils._double();
            }
            case FLOAT: {
                return AvroUtils._float();
            }
            case BYTE: {
                return AvroUtils._byte();
            }
            case BYTES: {
                return AvroUtils._bytes();
            }
            case SHORT: {
                return AvroUtils._short();
            }
            case CHARACTER: {
                return AvroUtils._character();
            }
            case BIG_DECIMAL: {
                return AvroUtils._decimal();
            }
            case DATE: {
                return AvroUtils._date();
            }
            case OBJECT: {
                return (Schema)((SchemaBuilder.StringBldr)SchemaBuilder.builder().stringBuilder().prop("java-class", "java.lang.Object")).endString();
            }
        }
        throw new UnsupportedOperationException("Unrecognized type " + talendType);
    }

    private static Schema.Field sqlType2Avro(int size, int scale, int dbtype, boolean nullable, String name, String dbColumnName, Object defaultValue, boolean isKey, Dbms mapping, String columnTypeName) {
        MappingType mt = mapping.getDbmsMapping(columnTypeName);
        Schema.Field field = null;
        boolean isIgnoreLength = false;
        boolean isIgnorePrecision = false;
        if (mt != null) {
            TalendType talendType = (TalendType)mt.getDefaultType();
            DbmsType sourceType = (DbmsType)mt.getSourceType();
            Schema schema = SchemaInferer.convertToAvro(talendType);
            field = SchemaInferer.wrap(nullable, schema, name);
            isIgnoreLength = sourceType.isIgnoreLength();
            isIgnorePrecision = sourceType.isIgnorePrecision();
        } else {
            field = SchemaInferer.wrap(nullable, AvroUtils._string(), name);
        }
        switch (dbtype) {
            case 12: {
                SchemaInferer.setPrecision(field, isIgnoreLength, size);
                break;
            }
            case 4: {
                SchemaInferer.setPrecision(field, isIgnoreLength, size);
                break;
            }
            case 3: {
                SchemaInferer.setPrecision(field, isIgnoreLength, size);
                SchemaInferer.setScale(field, isIgnorePrecision, scale);
                break;
            }
            case -5: {
                SchemaInferer.setPrecision(field, isIgnoreLength, size);
                break;
            }
            case 2: {
                SchemaInferer.setPrecision(field, isIgnoreLength, size);
                SchemaInferer.setScale(field, isIgnorePrecision, scale);
                break;
            }
            case -6: {
                SchemaInferer.setPrecision(field, isIgnoreLength, size);
                break;
            }
            case 8: {
                SchemaInferer.setPrecision(field, isIgnoreLength, size);
                SchemaInferer.setScale(field, isIgnorePrecision, scale);
                break;
            }
            case 6: {
                SchemaInferer.setPrecision(field, isIgnoreLength, size);
                SchemaInferer.setScale(field, isIgnorePrecision, scale);
                break;
            }
            case 91: {
                SchemaInferer.setPrecision(field, isIgnoreLength, size);
                SchemaInferer.setScale(field, isIgnorePrecision, scale);
                field.addProp("talend.field.pattern", "yyyy-MM-dd");
                break;
            }
            case 92: {
                SchemaInferer.setPrecision(field, isIgnoreLength, size);
                SchemaInferer.setScale(field, isIgnorePrecision, scale);
                field.addProp("talend.field.pattern", "HH:mm:ss");
                break;
            }
            case 93: {
                SchemaInferer.setPrecision(field, isIgnoreLength, size);
                SchemaInferer.setScale(field, isIgnorePrecision, scale);
                field.addProp("talend.field.pattern", "yyyy-MM-dd HH:mm:ss.SSS");
                break;
            }
            case 16: {
                break;
            }
            case 7: {
                SchemaInferer.setPrecision(field, isIgnoreLength, size);
                SchemaInferer.setScale(field, isIgnorePrecision, scale);
                break;
            }
            case 5: {
                SchemaInferer.setPrecision(field, isIgnoreLength, size);
                break;
            }
            case -1: {
                SchemaInferer.setPrecision(field, isIgnoreLength, size);
                break;
            }
            case 1: {
                SchemaInferer.setPrecision(field, isIgnoreLength, size);
                break;
            }
            default: {
                SchemaInferer.setPrecision(field, isIgnoreLength, size);
                SchemaInferer.setScale(field, isIgnorePrecision, scale);
            }
        }
        field.addProp("talend.field.dbType", columnTypeName);
        field.addProp("talend.field.dbColumnName", dbColumnName);
        if (defaultValue != null) {
            field.addProp("talend.field.default", String.valueOf(defaultValue));
        }
        if (isKey) {
            field.addProp("talend.field.isKey", "true");
        }
        return field;
    }

    private static void setPrecision(Schema.Field field, boolean ignorePrecision, int precision) {
        if (ignorePrecision) {
            return;
        }
        field.addProp("talend.field.length", String.valueOf(precision));
    }

    private static void setScale(Schema.Field field, boolean ignoreScale, int scale) {
        if (ignoreScale) {
            return;
        }
        field.addProp("talend.field.precision", String.valueOf(scale));
    }

    private static Schema.Field wrap(boolean nullable, Schema base, String name) {
        Schema schema = nullable ? (Schema)SchemaBuilder.builder().nullable().type(base) : base;
        return new Schema.Field(name, schema, null, (JsonNode)null);
    }
}

