/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.runtime.reader;

import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.talend.components.api.component.runtime.AbstractBoundedReader;
import org.talend.components.api.component.runtime.BoundedSource;
import org.talend.components.api.component.runtime.Result;
import org.talend.components.api.container.RuntimeContainer;
import org.talend.components.common.avro.JDBCAvroRegistryInfluencer;
import org.talend.components.common.avro.JDBCResultSetIndexedRecordConverter;
import org.talend.components.jdbc.CommonUtils;
import org.talend.components.jdbc.JdbcComponentErrorsCode;
import org.talend.components.jdbc.RuntimeSettingProvider;
import org.talend.components.jdbc.runtime.JDBCSource;
import org.talend.components.jdbc.runtime.JdbcRuntimeUtils;
import org.talend.components.jdbc.runtime.setting.AllSetting;
import org.talend.daikon.avro.AvroUtils;
import org.talend.daikon.avro.converter.IndexedRecordConverter;
import org.talend.daikon.exception.error.ErrorCode;

public class JDBCInputReader
extends AbstractBoundedReader<IndexedRecord> {
    protected RuntimeSettingProvider properties;
    private AllSetting setting;
    protected RuntimeContainer container;
    protected Connection conn;
    protected ResultSet resultSet;
    private transient IndexedRecordConverter<ResultSet, IndexedRecord> converter;
    private transient Schema querySchema;
    private JDBCSource source;
    private Statement statement;
    private Result result;
    private boolean useExistedConnection;
    private int readLimit = -1;
    private IndexedRecord currentRecord;

    public JDBCInputReader(RuntimeContainer container, JDBCSource source, RuntimeSettingProvider props) {
        super((BoundedSource)source);
        this.container = container;
        this.properties = props;
        this.setting = props.getRuntimeSetting();
        this.source = (JDBCSource)this.getCurrentSource();
        this.useExistedConnection = this.setting.getReferencedComponentId() != null;
    }

    public JDBCInputReader(RuntimeContainer container, JDBCSource source, RuntimeSettingProvider props, int readLimit) {
        this(container, source, props);
        this.readLimit = readLimit;
    }

    private Schema getSchema() throws IOException, SQLException {
        if (this.querySchema == null) {
            boolean includeDynamic;
            this.querySchema = this.setting.getSchema();
            if (AvroUtils.isSchemaEmpty((Schema)this.querySchema)) {
                this.querySchema = this.source.infer(this.resultSet.getMetaData(), this.container);
            }
            if (includeDynamic = AvroUtils.isIncludeAllFields((Schema)this.querySchema)) {
                Schema runtimeSchema4ResultSet = this.source.infer(this.resultSet.getMetaData(), this.container);
                this.querySchema = CommonUtils.mergeRuntimeSchema2DesignSchema4Dynamic((Schema)this.querySchema, (Schema)runtimeSchema4ResultSet);
            }
            if (this.setting.trim()) {
                return this.querySchema;
            }
            List trimColumnLabels = this.setting.getTrimColumns();
            List trims = this.setting.getTrims();
            HashMap<Integer, Boolean> trimMap = new HashMap<Integer, Boolean>();
            boolean defaultTrim = includeDynamic ? (Boolean)trims.get(Integer.valueOf(this.querySchema.getProp("di.dynamic.column.position"))) : false;
            int i = 0;
            block0: for (Schema.Field field : this.querySchema.getFields()) {
                int j = 0;
                trimMap.put(++i, defaultTrim);
                for (String trimColumnLabel : trimColumnLabels) {
                    if (trimColumnLabel.equals(field.name())) {
                        Boolean trim = (Boolean)trims.get(j);
                        trimMap.put(i, trim);
                        continue block0;
                    }
                    ++j;
                }
            }
            this.setting.setTrimMap(trimMap);
        }
        return this.querySchema;
    }

    private IndexedRecordConverter<ResultSet, IndexedRecord> getConverter(ResultSet resultSet) throws IOException, SQLException {
        if (this.converter == null) {
            this.converter = this.source.getConverter();
            if (this.converter instanceof JDBCResultSetIndexedRecordConverter) {
                ((JDBCResultSetIndexedRecordConverter)this.converter).setInfluencer((JDBCAvroRegistryInfluencer)this.setting);
            }
            this.converter.setSchema(this.getSchema());
            int sizeInResultSet = resultSet.getMetaData().getColumnCount();
            if (this.converter instanceof JDBCResultSetIndexedRecordConverter) {
                ((JDBCResultSetIndexedRecordConverter)this.converter).setSizeInResultSet(sizeInResultSet);
            }
        }
        return this.converter;
    }

    public boolean start() throws IOException {
        if (this.container != null) {
            this.container.setComponentData(this.container.getCurrentComponentId(), CommonUtils.getStudioNameFromProperty((String)"query"), (Object)this.setting.getSql());
        }
        this.result = new Result();
        boolean usePreparedStatement = this.setting.getUsePreparedStatement();
        try {
            this.conn = this.source.getConnection(this.container);
            String driverClass = this.setting.getDriverClass();
            if (driverClass != null && driverClass.toLowerCase().contains("mysql")) {
                if (usePreparedStatement) {
                    PreparedStatement prepared_statement = this.conn.prepareStatement(this.setting.getSql(), 1003, 1007);
                    JdbcRuntimeUtils.setPreparedStatement(prepared_statement, this.setting.getIndexs(), this.setting.getTypes(), this.setting.getValues());
                    this.statement = prepared_statement;
                } else {
                    this.statement = this.conn.createStatement(1003, 1007);
                }
                Class<?> clazz = this.statement.getClass();
                try {
                    Method method = clazz.getMethod("enableStreamingResults", new Class[0]);
                    if (method != null) {
                        method.invoke((Object)this.statement, new Object[0]);
                    }
                }
                catch (Exception exception) {}
            } else if (usePreparedStatement) {
                PreparedStatement prepared_statement = this.conn.prepareStatement(this.setting.getSql());
                JdbcRuntimeUtils.setPreparedStatement(prepared_statement, this.setting.getIndexs(), this.setting.getTypes(), this.setting.getValues());
                this.statement = prepared_statement;
            } else {
                this.statement = this.conn.createStatement();
            }
            if (this.setting.getUseCursor()) {
                this.statement.setFetchSize(this.setting.getCursor());
            }
            this.resultSet = usePreparedStatement ? ((PreparedStatement)this.statement).executeQuery() : this.statement.executeQuery(this.setting.getSql());
            return this.haveNext();
        }
        catch (SQLException e) {
            throw CommonUtils.newComponentException((ErrorCode)JdbcComponentErrorsCode.SQL_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw CommonUtils.newComponentException((Throwable)e);
        }
    }

    private boolean haveNext() throws SQLException, IOException {
        boolean haveNext = this.resultSet.next();
        if (haveNext) {
            ++this.result.totalCount;
            this.currentRecord = (IndexedRecord)this.getConverter(this.resultSet).convertToAvro((Object)this.resultSet);
        }
        return haveNext;
    }

    public boolean advance() throws IOException {
        try {
            return this.haveNext();
        }
        catch (SQLException e) {
            throw CommonUtils.newComponentException((Throwable)e);
        }
    }

    public IndexedRecord getCurrent() throws NoSuchElementException {
        if (this.currentRecord == null) {
            throw new NoSuchElementException("start() wasn't called");
        }
        return this.currentRecord;
    }

    public void close() throws IOException {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
                this.resultSet = null;
            }
            if (this.statement != null) {
                this.statement.close();
                this.statement = null;
            }
            if (!this.useExistedConnection && this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException e) {
            throw CommonUtils.newComponentException((Throwable)e);
        }
    }

    public Map<String, Object> getReturnValues() {
        return this.result.toMap();
    }
}

