/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.runtime.dataprep;

import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.talend.components.api.component.runtime.Reader;
import org.talend.components.api.component.runtime.ReaderDataProvider;
import org.talend.components.api.container.RuntimeContainer;
import org.talend.components.common.dataset.DatasetProperties;
import org.talend.components.common.dataset.runtime.DatasetRuntime;
import org.talend.components.jdbc.dataset.JDBCDatasetProperties;
import org.talend.components.jdbc.runtime.JDBCSource;
import org.talend.components.jdbc.runtime.JDBCSourceOrSink;
import org.talend.components.jdbc.runtime.reader.JDBCInputReader;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.java8.Consumer;
import org.talend.daikon.properties.ValidationResult;

public class JDBCDatasetRuntime
implements DatasetRuntime<JDBCDatasetProperties> {
    private static final long serialVersionUID = 5829335010543623248L;
    private JDBCDatasetProperties dataset;
    private RuntimeContainer container;

    public ValidationResult initialize(RuntimeContainer container, JDBCDatasetProperties properties) {
        this.dataset = properties;
        this.dataset.getRuntimeSetting().setReadOnly(Boolean.valueOf(true));
        this.container = container;
        return ValidationResult.OK;
    }

    public Schema getSchema() {
        JDBCSourceOrSink jss = new JDBCSourceOrSink();
        jss.initialize(this.container, (DatasetProperties)this.dataset);
        return jss.getSchemaFromQuery(this.container, this.dataset.getRuntimeSetting().getSql());
    }

    private void throwExceptionIfValidationResultIsError(ValidationResult validationResult) {
        if (validationResult == null) {
            return;
        }
        if (validationResult.getStatus() == ValidationResult.Result.ERROR) {
            throw TalendRuntimeException.createUnexpectedException((String)validationResult.getMessage());
        }
    }

    public void getSample(int limit, Consumer<IndexedRecord> consumer) {
        JDBCSource js = new JDBCSource();
        this.throwExceptionIfValidationResultIsError(js.initialize(this.container, (DatasetProperties)this.dataset));
        this.throwExceptionIfValidationResultIsError(js.validate(this.container));
        JDBCInputReader reader = (JDBCInputReader)js.createReader(this.container, limit);
        ReaderDataProvider readerDataProvider = new ReaderDataProvider((Reader)reader, limit, consumer);
        readerDataProvider.retrieveData();
    }
}

