/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.runtime;

import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.api.container.RuntimeContainer;
import org.talend.components.api.properties.ComponentProperties;
import org.talend.components.common.avro.JDBCAvroRegistryInfluencer;
import org.talend.components.common.avro.JDBCResultSetIndexedRecordConverter;
import org.talend.components.common.avro.JDBCTableMetadata;
import org.talend.components.common.config.jdbc.Dbms;
import org.talend.components.common.dataset.DatasetProperties;
import org.talend.components.common.datastore.DatastoreProperties;
import org.talend.components.jdbc.CommonUtils;
import org.talend.components.jdbc.RuntimeSettingProvider;
import org.talend.components.jdbc.avro.JDBCAvroRegistryString;
import org.talend.components.jdbc.avro.ResultSetStringRecordConverter;
import org.talend.components.jdbc.module.DBTypes;
import org.talend.components.jdbc.runtime.JdbcRuntimeUtils;
import org.talend.components.jdbc.runtime.schemainfer.SchemaInferer;
import org.talend.components.jdbc.runtime.setting.AllSetting;
import org.talend.components.jdbc.runtime.setting.JdbcRuntimeSourceOrSinkDefault;
import org.talend.daikon.NamedThing;
import org.talend.daikon.SimpleNamedThing;
import org.talend.daikon.avro.converter.IndexedRecordConverter;
import org.talend.daikon.exception.ExceptionContext;
import org.talend.daikon.exception.error.CommonErrorCodes;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.daikon.properties.ValidationResult;

public class JDBCSourceOrSink
extends JdbcRuntimeSourceOrSinkDefault {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCSourceOrSink.class);
    private static final long serialVersionUID = 1L;
    public RuntimeSettingProvider properties;
    protected AllSetting setting;
    private transient IndexedRecordConverter<ResultSet, IndexedRecord> converter;
    private boolean work4dataprep = false;
    private Dbms typeMapping = null;

    public ValidationResult initialize(RuntimeContainer runtime, ComponentProperties properties) {
        this.properties = (RuntimeSettingProvider)properties;
        this.setting = this.properties.getRuntimeSetting();
        this.converter = new JDBCResultSetIndexedRecordConverter();
        ((JDBCResultSetIndexedRecordConverter)this.converter).setInfluencer((JDBCAvroRegistryInfluencer)this.setting);
        return ValidationResult.OK;
    }

    public ValidationResult initialize(RuntimeContainer runtime, DatastoreProperties properties) {
        this.properties = (RuntimeSettingProvider)properties;
        this.setting = this.properties.getRuntimeSetting();
        this.converter = new ResultSetStringRecordConverter();
        this.work4dataprep = true;
        return ValidationResult.OK;
    }

    public ValidationResult initialize(RuntimeContainer runtime, DatasetProperties properties) {
        this.properties = (RuntimeSettingProvider)properties;
        this.setting = this.properties.getRuntimeSetting();
        this.converter = new ResultSetStringRecordConverter();
        this.work4dataprep = true;
        return ValidationResult.OK;
    }

    public void setDBTypeMapping(Dbms mapping) {
        this.typeMapping = mapping;
    }

    public ValidationResult validate(RuntimeContainer runtime) {
        return JdbcRuntimeUtils.validate(runtime, this);
    }

    public List<NamedThing> getSchemaNames(RuntimeContainer runtime) throws IOException {
        ArrayList<NamedThing> result = new ArrayList<NamedThing>();
        try (Connection conn = this.connect(runtime);){
            DatabaseMetaData dbMetaData = conn.getMetaData();
            Set<String> tableTypes = this.getAvailableTableTypes(dbMetaData);
            String database_schema = this.getDatabaseSchema();
            try (ResultSet resultset = dbMetaData.getTables(null, database_schema, null, tableTypes.toArray(new String[0]));){
                while (resultset.next()) {
                    String tablename = resultset.getString("TABLE_NAME");
                    if (tablename == null) {
                        tablename = resultset.getString("SYNONYM_NAME");
                    }
                    result.add((NamedThing)new SimpleNamedThing(tablename, tablename));
                }
            }
        }
        catch (Exception e) {
            throw CommonUtils.newComponentException((ErrorCode)CommonErrorCodes.UNEXPECTED_EXCEPTION, (Throwable)e, (ExceptionContext)ExceptionContext.withBuilder().put("message", (Object)e.getMessage()).build());
        }
        return result;
    }

    private String getDatabaseSchema() {
        String jdbc_url = this.setting.getJdbcUrl();
        String username = this.setting.getUsername();
        if (jdbc_url != null && username != null && jdbc_url.contains("oracle")) {
            return username.toUpperCase();
        }
        return null;
    }

    private Set<String> getAvailableTableTypes(DatabaseMetaData dbMetaData) throws SQLException {
        HashSet<String> availableTableTypes = new HashSet<String>();
        List<String> neededTableTypes = Arrays.asList("TABLE", "VIEW", "SYNONYM");
        try (ResultSet rsTableTypes = dbMetaData.getTableTypes();){
            while (rsTableTypes.next()) {
                String currentTableType = rsTableTypes.getString("TABLE_TYPE");
                if (currentTableType == null) {
                    currentTableType = "";
                }
                if ("BASE TABLE".equalsIgnoreCase(currentTableType = currentTableType.trim())) {
                    currentTableType = "TABLE";
                }
                if (!neededTableTypes.contains(currentTableType)) continue;
                availableTableTypes.add(currentTableType);
            }
        }
        return availableTableTypes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Schema getEndpointSchema(RuntimeContainer runtime, String tableName) throws IOException {
        try (Connection conn = this.connect(runtime);){
            JDBCTableMetadata tableMetadata = new JDBCTableMetadata();
            tableMetadata.setDatabaseMetaData(conn.getMetaData()).setTablename(tableName);
            Schema schema = this.infer(tableMetadata, runtime);
            return schema;
        }
        catch (Exception e) {
            throw CommonUtils.newComponentException((ErrorCode)CommonErrorCodes.UNEXPECTED_EXCEPTION, (Throwable)e, (ExceptionContext)ExceptionContext.withBuilder().put("message", (Object)e.getMessage()).build());
        }
    }

    /*
     * Exception decompiling
     */
    public Schema getSchemaFromQuery(RuntimeContainer runtime, String query) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Connection connect(RuntimeContainer runtime) throws ClassNotFoundException, SQLException {
        AllSetting setting = this.properties.getRuntimeSetting();
        Connection conn = JdbcRuntimeUtils.createConnectionOrGetFromSharedConnectionPoolOrDataSource(runtime, setting, this.work4dataprep);
        if (setting.getUseAutoCommit()) {
            conn.setAutoCommit(setting.getAutocommit());
        }
        if (runtime != null) {
            runtime.setComponentData("conn", runtime.getCurrentComponentId(), (Object)conn);
            runtime.setComponentData("url", runtime.getCurrentComponentId(), (Object)setting.getJdbcUrl());
            runtime.setComponentData("username", runtime.getCurrentComponentId(), (Object)setting.getUsername());
        }
        return conn;
    }

    public Schema infer(JDBCTableMetadata tableMetadata, RuntimeContainer runtime) throws SQLException {
        if (this.work4dataprep) {
            return JDBCAvroRegistryString.get().inferSchema(tableMetadata);
        }
        Dbms mapping = this.getDBMapping(runtime);
        return SchemaInferer.infer(tableMetadata, mapping);
    }

    public Schema infer(ResultSetMetaData metadata, RuntimeContainer runtime) throws SQLException {
        if (this.work4dataprep) {
            return JDBCAvroRegistryString.get().inferSchema(metadata);
        }
        Dbms mapping = this.getDBMapping(runtime);
        return SchemaInferer.infer(metadata, mapping);
    }

    private Dbms getDBMapping(RuntimeContainer runtime) {
        Dbms mapping = null;
        if (this.typeMapping != null) {
            mapping = this.typeMapping;
        } else if (runtime != null) {
            URL mappingFileDir = (URL)runtime.getComponentData(runtime.getCurrentComponentId(), "MAPPINGS_URL");
            mapping = CommonUtils.getMapping((URL)mappingFileDir, (AllSetting)this.setting, null, (DBTypes)this.setting.getDbMapping());
        }
        return mapping;
    }

    public IndexedRecordConverter<ResultSet, IndexedRecord> getConverter() {
        return this.converter;
    }
}

