/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.runtime;

import java.sql.Connection;
import java.sql.SQLException;
import org.talend.components.api.component.runtime.Result;
import org.talend.components.api.component.runtime.Sink;
import org.talend.components.api.component.runtime.WriteOperation;
import org.talend.components.api.container.RuntimeContainer;
import org.talend.components.jdbc.runtime.JDBCOutputWriteOperation;
import org.talend.components.jdbc.runtime.JDBCSourceOrSink;
import org.talend.components.jdbc.runtime.JdbcRuntimeUtils;

public class JDBCSink
extends JDBCSourceOrSink
implements Sink {
    private static final long serialVersionUID = 3228265006313531905L;

    public WriteOperation<Result> createWriteOperation() {
        return new JDBCOutputWriteOperation(this);
    }

    @Override
    public Connection connect(RuntimeContainer runtime) throws ClassNotFoundException, SQLException {
        String refComponentId = this.setting.getReferencedComponentId();
        if (refComponentId != null) {
            return JdbcRuntimeUtils.fetchConnectionFromContextOrCreateNew(this.setting, runtime);
        }
        Connection conn = JdbcRuntimeUtils.createConnectionOrGetFromSharedConnectionPoolOrDataSource(runtime, this.setting, false);
        Integer commitEvery = this.setting.getCommitEvery();
        if (commitEvery != null && commitEvery > 0) {
            conn.setAutoCommit(false);
        }
        return conn;
    }
}

