/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.runtime;

import org.talend.components.api.component.runtime.Result;
import org.talend.components.api.component.runtime.Sink;
import org.talend.components.api.component.runtime.Writer;
import org.talend.components.api.container.RuntimeContainer;
import org.talend.components.jdbc.RuntimeSettingProvider;
import org.talend.components.jdbc.runtime.DefaultWriteOperation;
import org.talend.components.jdbc.runtime.JDBCSink;
import org.talend.components.jdbc.runtime.writer.JDBCOutputDeleteWriter;
import org.talend.components.jdbc.runtime.writer.JDBCOutputInsertOrUpdateWriter;
import org.talend.components.jdbc.runtime.writer.JDBCOutputInsertWriter;
import org.talend.components.jdbc.runtime.writer.JDBCOutputUpdateOrInsertWriter;
import org.talend.components.jdbc.runtime.writer.JDBCOutputUpdateWriter;
import org.talend.components.jdbc.tjdbcoutput.TJDBCOutputProperties;

public class JDBCOutputWriteOperation
extends DefaultWriteOperation {
    private static final long serialVersionUID = 1L;

    public JDBCOutputWriteOperation(Sink sink) {
        super(sink);
    }

    public Writer<Result> createWriter(RuntimeContainer runtimeContainer) {
        RuntimeSettingProvider properties = ((JDBCSink)this.getSink()).properties;
        TJDBCOutputProperties.DataAction dataAction = properties.getRuntimeSetting().getDataAction();
        switch (dataAction) {
            case INSERT: {
                return new JDBCOutputInsertWriter(this, runtimeContainer);
            }
            case UPDATE: {
                return new JDBCOutputUpdateWriter(this, runtimeContainer);
            }
            case DELETE: {
                return new JDBCOutputDeleteWriter(this, runtimeContainer);
            }
            case INSERT_OR_UPDATE: {
                return new JDBCOutputInsertOrUpdateWriter(this, runtimeContainer);
            }
            case UPDATE_OR_INSERT: {
                return new JDBCOutputUpdateOrInsertWriter(this, runtimeContainer);
            }
        }
        return null;
    }
}

