/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.runtime;

import java.sql.Connection;
import java.sql.SQLException;
import org.talend.components.api.container.RuntimeContainer;
import org.talend.components.api.properties.ComponentProperties;
import org.talend.components.jdbc.CommonUtils;
import org.talend.components.jdbc.RuntimeSettingProvider;
import org.talend.components.jdbc.runtime.setting.JdbcRuntimeSourceOrSinkDefault;
import org.talend.daikon.properties.ValidationResult;
import org.talend.daikon.properties.ValidationResultMutable;

public class JDBCCloseSourceOrSink
extends JdbcRuntimeSourceOrSinkDefault {
    private static final long serialVersionUID = 1L;
    public ComponentProperties properties;

    public ValidationResult initialize(RuntimeContainer runtime, ComponentProperties properties) {
        this.properties = properties;
        return ValidationResult.OK;
    }

    public ValidationResult validate(RuntimeContainer runtime) {
        ValidationResultMutable vr = new ValidationResultMutable();
        try {
            this.doCloseAction(runtime);
        }
        catch (Exception ex) {
            vr.setStatus(ValidationResult.Result.ERROR);
            vr.setMessage(CommonUtils.correctExceptionInfo((Throwable)ex));
        }
        return vr;
    }

    public void doCloseAction(RuntimeContainer runtime) throws SQLException {
        String refComponentId = ((RuntimeSettingProvider)this.properties).getRuntimeSetting().getReferencedComponentId();
        if (refComponentId != null && runtime != null) {
            Connection conn = (Connection)runtime.getComponentData("conn", refComponentId);
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
        } else {
            throw new RuntimeException("Can't find the connection by the key");
        }
    }
}

