/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.avro;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.talend.daikon.avro.AvroUtils;
import org.talend.daikon.avro.converter.IndexedRecordConverter;
import org.talend.daikon.exception.TalendRuntimeException;

public class ResultSetStringRecordConverter
implements IndexedRecordConverter<ResultSet, IndexedRecord> {
    private Schema actualSchema;

    public Class<ResultSet> getDatumClass() {
        return ResultSet.class;
    }

    public ResultSet convertToDatum(IndexedRecord value) {
        throw new IndexedRecordConverter.UnmodifiableAdapterException("not supported");
    }

    public IndexedRecord convertToAvro(ResultSet resultSet) {
        GenericData.Record record = new GenericData.Record(this.actualSchema);
        try {
            ResultSetMetaData metadata = resultSet.getMetaData();
            int columnsNumber = metadata.getColumnCount();
            for (int i = 0; i < columnsNumber; ++i) {
                String columnValue = resultSet.getString(i + 1);
                record.put(i, (Object)columnValue);
            }
        }
        catch (SQLException e) {
            throw TalendRuntimeException.createUnexpectedException((Throwable)e);
        }
        return record;
    }

    public Schema getSchema() {
        return this.actualSchema;
    }

    public void setSchema(Schema schema) {
        this.actualSchema = Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)schema.isError());
        ArrayList<Schema.Field> stringFields = new ArrayList<Schema.Field>();
        for (Schema.Field field : schema.getFields()) {
            boolean nullable = AvroUtils.isNullable((Schema)field.schema());
            Schema stringSchema = AvroUtils._string();
            if (nullable) {
                stringSchema = AvroUtils.wrapAsNullable((Schema)stringSchema);
            }
            Schema.Field stringField = new Schema.Field(field.name(), stringSchema, field.doc(), field.defaultVal(), field.order());
            for (Map.Entry entry : field.getObjectProps().entrySet()) {
                stringField.addProp((String)entry.getKey(), entry.getValue());
            }
            stringFields.add(stringField);
        }
        this.actualSchema.setFields(stringFields);
        for (Map.Entry entry : schema.getObjectProps().entrySet()) {
            this.actualSchema.addProp((String)entry.getKey(), entry.getValue());
        }
    }
}

