/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.avro;

import java.sql.CallableStatement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.talend.components.common.avro.JDBCAvroRegistry;
import org.talend.components.jdbc.CommonUtils;
import org.talend.components.jdbc.module.SPParameterTable;
import org.talend.components.jdbc.runtime.setting.AllSetting;
import org.talend.daikon.avro.converter.AvroConverter;
import org.talend.daikon.avro.converter.IndexedRecordConverter;

public class JDBCSPIndexedRecordCreator {
    private Schema currentComponentSchema;
    private Schema outputSchema;
    AllSetting setting;
    private Map<Integer, AvroConverter> outputFieldLocation2AvroConverter = new HashMap<Integer, AvroConverter>();
    private int resultSetPostionOfOutputSchema = -1;
    private Map<Integer, Integer> autoPropagatedFieldsFromInputToOutput = new HashMap<Integer, Integer>();
    private boolean firstRowHaveCame = false;

    public void init(Schema currentComponentSchema, Schema outputSchema, AllSetting setting) {
        this.currentComponentSchema = currentComponentSchema;
        this.outputSchema = outputSchema;
        this.setting = setting;
        if (setting.isFunction()) {
            Schema.Field outField = CommonUtils.getField((Schema)currentComponentSchema, (String)setting.getReturnResultIn());
            Schema.Field outFieldInOutputSchema = CommonUtils.getField((Schema)outputSchema, (String)setting.getReturnResultIn());
            this.outputFieldLocation2AvroConverter.put(outFieldInOutputSchema.pos(), (AvroConverter)JDBCAvroRegistry.get().getSPConverter(outField, 1));
        }
        List parameterColumns = setting.getSchemaColumns4SPParameters();
        List pts = setting.getParameterTypes();
        if (pts != null) {
            int i = setting.isFunction() ? 2 : 1;
            int j = -1;
            for (String each : pts) {
                String columnName = (String)parameterColumns.get(++j);
                SPParameterTable.ParameterType pt = SPParameterTable.ParameterType.valueOf((String)each);
                if (SPParameterTable.ParameterType.RECORDSET == pt) {
                    Schema.Field outFieldInOutputSchema = CommonUtils.getField((Schema)outputSchema, (String)columnName);
                    this.resultSetPostionOfOutputSchema = outFieldInOutputSchema.pos();
                    continue;
                }
                if (SPParameterTable.ParameterType.OUT == pt || SPParameterTable.ParameterType.INOUT == pt) {
                    Schema.Field outField = CommonUtils.getField((Schema)currentComponentSchema, (String)columnName);
                    Schema.Field outFieldInOutputSchema = CommonUtils.getField((Schema)outputSchema, (String)columnName);
                    this.outputFieldLocation2AvroConverter.put(outFieldInOutputSchema.pos(), (AvroConverter)JDBCAvroRegistry.get().getSPConverter(outField, i));
                }
                ++i;
            }
        }
    }

    public IndexedRecord createOutputIndexedRecord(CallableStatement value, IndexedRecord inputRecord) {
        if (!this.firstRowHaveCame) {
            this.firstRowHaveCame = true;
            Schema inputSchema = null;
            if (inputRecord != null) {
                inputSchema = inputRecord.getSchema();
            }
            HashMap<String, Schema.Field> inputFieldMap = null;
            for (Schema.Field outputField : this.outputSchema.getFields()) {
                Schema.Field inputField;
                if (this.outputFieldLocation2AvroConverter.containsKey(outputField.pos()) || this.resultSetPostionOfOutputSchema == outputField.pos()) continue;
                if (inputSchema == null) break;
                List inputFields = inputSchema.getFields();
                if (inputFieldMap == null) {
                    inputFieldMap = new HashMap<String, Schema.Field>();
                    for (Schema.Field inputField2 : inputFields) {
                        inputFieldMap.put(inputField2.name(), inputField2);
                    }
                }
                if ((inputField = (Schema.Field)inputFieldMap.get(outputField.name())) == null) continue;
                this.autoPropagatedFieldsFromInputToOutput.put(outputField.pos(), inputField.pos());
            }
        }
        return new ResultSetIndexedRecord(value, inputRecord);
    }

    private class ResultSetIndexedRecord
    implements IndexedRecord {
        private Object[] values;

        public ResultSetIndexedRecord(CallableStatement result, IndexedRecord inputRecord) {
            try {
                List outputFields = JDBCSPIndexedRecordCreator.this.outputSchema.getFields();
                this.values = new Object[outputFields.size()];
                for (int i = 0; i < this.values.length; ++i) {
                    AvroConverter converter = (AvroConverter)JDBCSPIndexedRecordCreator.this.outputFieldLocation2AvroConverter.get(i);
                    if (converter != null) {
                        this.values[i] = converter.convertToAvro((Object)result);
                        continue;
                    }
                    if (JDBCSPIndexedRecordCreator.this.resultSetPostionOfOutputSchema == i) {
                        this.values[i] = result.getResultSet();
                        continue;
                    }
                    Integer inputLocation = (Integer)JDBCSPIndexedRecordCreator.this.autoPropagatedFieldsFromInputToOutput.get(i);
                    if (inputLocation == null || inputRecord == null) continue;
                    this.values[i] = inputRecord.get(inputLocation.intValue());
                }
            }
            catch (Exception e) {
                throw CommonUtils.newComponentException((Throwable)e);
            }
        }

        public Schema getSchema() {
            return JDBCSPIndexedRecordCreator.this.outputSchema;
        }

        public void put(int i, Object v) {
            throw new IndexedRecordConverter.UnmodifiableAdapterException();
        }

        public Object get(int i) {
            return this.values[i];
        }
    }
}

