/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.avro;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.talend.components.api.exception.ComponentException;
import org.talend.components.common.avro.JDBCTableMetadata;
import org.talend.daikon.avro.AvroRegistry;
import org.talend.daikon.avro.AvroUtils;
import org.talend.daikon.avro.NameUtil;
import org.talend.daikon.java8.SerializableFunction;

public class JDBCAvroRegistryString
extends AvroRegistry {
    private static final JDBCAvroRegistryString sInstance = new JDBCAvroRegistryString();

    public static JDBCAvroRegistryString get() {
        return sInstance;
    }

    protected JDBCAvroRegistryString() {
        this.registerSchemaInferrer(JDBCTableMetadata.class, (SerializableFunction)new SerializableFunction<JDBCTableMetadata, Schema>(){
            private static final long serialVersionUID = 1L;

            public Schema apply(JDBCTableMetadata t) {
                try {
                    return JDBCAvroRegistryString.this.inferSchemaResultSet(t);
                }
                catch (SQLException e) {
                    throw new ComponentException((Throwable)e);
                }
            }
        });
        this.registerSchemaInferrer(ResultSetMetaData.class, (SerializableFunction)new SerializableFunction<ResultSetMetaData, Schema>(){
            private static final long serialVersionUID = 1L;

            public Schema apply(ResultSetMetaData t) {
                try {
                    return JDBCAvroRegistryString.this.inferSchemaResultSetMetaData(t);
                }
                catch (SQLException e) {
                    throw new ComponentException((Throwable)e);
                }
            }
        });
    }

    protected Schema inferSchemaResultSetMetaData(ResultSetMetaData metadata) throws SQLException {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        HashSet<String> existNames = new HashSet<String>();
        int index = 0;
        int count = metadata.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            int size = metadata.getPrecision(i);
            int scale = metadata.getScale(i);
            boolean nullable = 1 == metadata.isNullable(i);
            int dbtype = metadata.getColumnType(i);
            String fieldName = metadata.getColumnLabel(i);
            String dbColumnName = metadata.getColumnName(i);
            boolean isKey = false;
            String validName = NameUtil.correct((String)fieldName, (int)index++, existNames);
            existNames.add(validName);
            Schema.Field field = this.sqlType2Avro(size, scale, dbtype, nullable, validName, dbColumnName, null, isKey);
            fields.add(field);
        }
        return Schema.createRecord((String)"DYNAMIC", null, null, (boolean)false, fields);
    }

    protected Schema inferSchemaResultSet(JDBCTableMetadata tableMetadata) throws SQLException {
        DatabaseMetaData databaseMetdata = tableMetadata.getDatabaseMetaData();
        Set<String> keys = this.getPrimaryKeys(databaseMetdata, tableMetadata.getCatalog(), tableMetadata.getDbSchema(), tableMetadata.getTablename());
        HashSet<String> existNames = new HashSet<String>();
        int index = 0;
        try (ResultSet metadata = databaseMetdata.getColumns(tableMetadata.getCatalog(), tableMetadata.getDbSchema(), tableMetadata.getTablename(), null);){
            if (!metadata.next()) {
                Schema schema = null;
                return schema;
            }
            ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
            String tablename = metadata.getString("TABLE_NAME");
            do {
                int size = metadata.getInt("COLUMN_SIZE");
                int scale = metadata.getInt("DECIMAL_DIGITS");
                int dbtype = metadata.getInt("DATA_TYPE");
                boolean nullable = 1 == metadata.getInt("NULLABLE");
                String columnName = metadata.getString("COLUMN_NAME");
                boolean isKey = keys.contains(columnName);
                String defaultValue = metadata.getString("COLUMN_DEF");
                String validName = NameUtil.correct((String)columnName, (int)index++, existNames);
                existNames.add(validName);
                Schema.Field field = this.sqlType2Avro(size, scale, dbtype, nullable, validName, columnName, defaultValue, isKey);
                fields.add(field);
            } while (metadata.next());
            Schema schema = Schema.createRecord((String)NameUtil.correct((String)tablename, (int)0, new HashSet()), null, null, (boolean)false, fields);
            return schema;
        }
    }

    private Set<String> getPrimaryKeys(DatabaseMetaData databaseMetdata, String catalogName, String schemaName, String tableName) throws SQLException {
        HashSet<String> result = new HashSet<String>();
        try (ResultSet resultSet = databaseMetdata.getPrimaryKeys(catalogName, schemaName, tableName);){
            while (resultSet.next()) {
                result.add(resultSet.getString("COLUMN_NAME"));
            }
        }
        return result;
    }

    protected Schema.Field sqlType2Avro(int size, int scale, int dbtype, boolean isNullable, String name, String dbColumnName, Object defaultValue, boolean isKey) {
        Schema.Field field = null;
        Schema schema = null;
        switch (dbtype) {
            case 12: {
                schema = AvroUtils._string();
                field = this.wrap(isNullable, schema, name);
                field.addProp("talend.field.length", (Object)size);
                break;
            }
            case 4: {
                schema = AvroUtils._string();
                field = this.wrap(isNullable, schema, name);
                field.addProp("talend.field.precision", (Object)size);
                break;
            }
            case 3: {
                schema = AvroUtils._string();
                field = this.wrap(isNullable, schema, name);
                field.addProp("talend.field.precision", (Object)size);
                field.addProp("talend.field.scale", (Object)scale);
                break;
            }
            case -5: {
                schema = AvroUtils._string();
                field = this.wrap(isNullable, schema, name);
                field.addProp("talend.field.precision", (Object)size);
                break;
            }
            case 2: {
                schema = AvroUtils._string();
                field = this.wrap(isNullable, schema, name);
                field.addProp("talend.field.precision", (Object)size);
                field.addProp("talend.field.scale", (Object)scale);
                break;
            }
            case -6: {
                schema = AvroUtils._string();
                field = this.wrap(isNullable, schema, name);
                field.addProp("talend.field.precision", (Object)size);
                break;
            }
            case 8: {
                schema = AvroUtils._string();
                field = this.wrap(isNullable, schema, name);
                break;
            }
            case 6: {
                schema = AvroUtils._string();
                field = this.wrap(isNullable, schema, name);
                break;
            }
            case 91: {
                schema = AvroUtils._string();
                field = this.wrap(isNullable, schema, name);
                field.addProp("talend.field.pattern", "yyyy-MM-dd");
                break;
            }
            case 92: {
                schema = AvroUtils._string();
                field = this.wrap(isNullable, schema, name);
                field.addProp("talend.field.pattern", "HH:mm:ss");
                break;
            }
            case 93: {
                schema = AvroUtils._string();
                field = this.wrap(isNullable, schema, name);
                field.addProp("talend.field.pattern", "yyyy-MM-dd HH:mm:ss.SSS");
                break;
            }
            case 16: {
                schema = AvroUtils._string();
                field = this.wrap(isNullable, schema, name);
                break;
            }
            case 7: {
                schema = AvroUtils._string();
                field = this.wrap(isNullable, schema, name);
                break;
            }
            case 5: {
                schema = AvroUtils._string();
                field = this.wrap(isNullable, schema, name);
                field.addProp("talend.field.precision", (Object)size);
                break;
            }
            case -1: {
                schema = AvroUtils._string();
                field = this.wrap(isNullable, schema, name);
                field.addProp("talend.field.length", (Object)size);
                break;
            }
            case 1: {
                schema = AvroUtils._string();
                field = this.wrap(isNullable, schema, name);
                field.addProp("talend.field.length", (Object)size);
                break;
            }
            default: {
                schema = AvroUtils._string();
                field = this.wrap(isNullable, schema, name);
            }
        }
        field.addProp("talend.field.dbType", (Object)dbtype);
        field.addProp("talend.field.dbColumnName", dbColumnName);
        if (defaultValue != null) {
            field.addProp("talend.field.default", defaultValue);
        }
        if (isKey) {
            field.addProp("talend.field.isKey", "true");
        }
        return field;
    }

    protected Schema.Field wrap(boolean nullable, Schema base, String name) {
        Schema schema = nullable ? (Schema)SchemaBuilder.builder().nullable().type(base) : base;
        return new Schema.Field(name, schema, null, null);
    }
}

