/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.avro;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.avro.Schema;
import org.talend.daikon.avro.AvroUtils;
import org.talend.daikon.avro.converter.AvroConverter;

public class DateToStringConverter
implements AvroConverter<Date, String> {
    public static final String DEFAULT_PATTERN = "dd-MM-yyyy hh:mm:ss:SSS";
    private DateFormat dateFormat;

    public DateToStringConverter() {
        this(DEFAULT_PATTERN);
    }

    public DateToStringConverter(String datePattern) {
        this.dateFormat = new SimpleDateFormat(datePattern);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public Schema getSchema() {
        return AvroUtils._string();
    }

    public Class<Date> getDatumClass() {
        return Date.class;
    }

    public Date convertToDatum(String value) {
        return null;
    }

    public String convertToAvro(Date value) {
        String avroString = this.dateFormat.format(value);
        return avroString;
    }
}

