/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JExpressionImpl;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JGenerable;
import com.sun.codemodel.JStatement;
import java.util.Objects;

public class JCompoundAssignment
extends JExpressionImpl
implements JStatement {
    private JAssignmentTarget leftHandSide = null;
    private JExpression rightHandSide = null;
    private String operator = null;

    public JCompoundAssignment(JAssignmentTarget leftHandSide, JExpression rightHandSide, String operator) {
        this.leftHandSide = Objects.requireNonNull(leftHandSide);
        this.rightHandSide = Objects.requireNonNull(rightHandSide);
        this.operator = Objects.requireNonNull(operator);
        switch (operator) {
            case "+=": 
            case "-=": {
                break;
            }
            default: {
                throw new IllegalArgumentException(operator);
            }
        }
    }

    public void generate(JFormatter formatter) {
        formatter.g((JGenerable)this.leftHandSide).p(JCompoundAssignment.padOperator(this.operator)).g((JGenerable)this.rightHandSide);
    }

    public void state(JFormatter formatter) {
        formatter.g((JGenerable)this).p(";");
        formatter.nl();
    }

    private static String padOperator(String operator) {
        switch (operator) {
            case "-=": {
                return " -=";
            }
        }
        return operator;
    }
}

