/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.token;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.UUID;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenGenerator.class);

    private TokenGenerator() {
    }

    public static String generateMachineToken(Function<String, String> cryptoFunction) {
        if (cryptoFunction == null) {
            throw new IllegalArgumentException("Crypto function cannot be null.");
        }
        StringBuilder sb = new StringBuilder();
        try {
            InetAddress loopBackAddress = InetAddress.getLocalHost();
            Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
            while (networks.hasMoreElements()) {
                NetworkInterface network = networks.nextElement();
                byte[] mac = network.getHardwareAddress();
                if (mac == null) continue;
                StringBuilder macAddress = new StringBuilder();
                for (byte macByte : mac) {
                    macAddress.append(String.format("%02X", macByte));
                }
                if ("0000000000E0".equals(macAddress.toString())) continue;
                sb.append(macAddress.toString());
            }
            sb.append('-');
            sb.append(System.getProperty("os.name"));
            sb.append(System.getProperty("os.version"));
            sb.append('-').append(loopBackAddress.getHostName());
        }
        catch (SocketException | UnknownHostException e) {
            LOGGER.debug("Unable to get local MAC address, fall back to UUID.", (Throwable)e);
            sb.append(UUID.randomUUID().toString());
        }
        String machineId = cryptoFunction.apply(sb.toString());
        LOGGER.debug("Generated machine token: {}", (Object)machineId);
        return machineId;
    }
}

