/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.serialize.jsonschema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import java.util.List;
import org.apache.avro.Schema;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.PropertiesList;
import org.talend.daikon.properties.ReferenceProperties;
import org.talend.daikon.properties.presentation.Form;
import org.talend.daikon.properties.presentation.Widget;
import org.talend.daikon.properties.property.Property;
import org.talend.daikon.serialize.jsonschema.JsonBaseTool;

public class JsonDataGenerator {
    protected ObjectNode genData(Properties properties, String formName, String definitionName) {
        Form mainForm = properties.getPreferredForm(formName);
        ObjectNode propertiesJsonDataObject = this.processTPropertiesData(mainForm, properties);
        propertiesJsonDataObject.put("@definitionName", definitionName);
        return propertiesJsonDataObject;
    }

    ObjectNode processTPropertiesData(Form form, Properties cProperties) {
        ObjectNode rootNode = JsonNodeFactory.instance.objectNode();
        List<Property> propertyList = JsonBaseTool.getSubProperty(cProperties);
        for (Property property : propertyList) {
            this.processTPropertyValue(form, cProperties.getClass().getClassLoader(), property, rootNode);
        }
        List<Properties> propertiesList = JsonBaseTool.getSubProperties(cProperties);
        for (Properties properties : propertiesList) {
            String name = properties.getName();
            if (properties instanceof ReferenceProperties) {
                ReferenceProperties referenceProperties = (ReferenceProperties)properties;
                rootNode.put(properties.getName(), referenceProperties.referenceDefinitionName.getValue());
                continue;
            }
            if (properties instanceof PropertiesList) {
                ArrayNode arrayNode = rootNode.putArray(properties.getName());
                for (Properties props : ((PropertiesList)properties).getPropertiesList()) {
                    this.fillValue(form, arrayNode, Properties.class, (Object)props);
                }
                continue;
            }
            rootNode.set(name, (JsonNode)this.processTPropertiesData(form, properties));
        }
        return rootNode;
    }

    private ObjectNode processTPropertyValue(Form form, ClassLoader classLoader, Property property, ObjectNode node) {
        String placeholder;
        Widget widget;
        Widget widget2 = widget = form != null ? form.getWidget(property.getName()) : null;
        if (widget != null && (placeholder = (String)widget.getConfigurationValue("widget.conf.placeholder")) != null && (property.getValue() == null || property.getValue().equals(""))) {
            return node;
        }
        String javaType = property.getType();
        String pName = property.getName();
        Object pValue = property.getValue();
        if (pValue != null) {
            if (JsonBaseTool.isListClass(javaType)) {
                Class type = JsonBaseTool.findClass(classLoader, JsonBaseTool.getListInnerClassName(javaType));
                ArrayNode arrayNode = node.putArray(pName);
                for (Object value : (List)pValue) {
                    this.fillValue(form, arrayNode, type, value);
                }
            } else {
                this.fillValue(node, JsonBaseTool.findClass(classLoader, javaType), pName, pValue);
            }
        }
        return node;
    }

    private void fillValue(Form form, ArrayNode node, Class type, Object value) {
        if (String.class.equals((Object)type)) {
            node.add((String)value);
        } else if (Integer.class.equals((Object)type)) {
            node.add((Integer)value);
        } else if (type.isEnum()) {
            node.add(value.toString());
        } else if (Boolean.class.equals((Object)type)) {
            node.add((Boolean)value);
        } else if (Schema.class.equals((Object)type)) {
            node.add(value.toString());
        } else if (Double.class.equals((Object)type)) {
            node.add((Double)value);
        } else if (Float.class.equals((Object)type)) {
            node.add((Float)value);
        } else if (Long.class.equals((Object)type)) {
            node.add((Long)value);
        } else if (Date.class.equals((Object)type)) {
            node.add(JsonBaseTool.dateFormatter.format((Date)value));
        } else if (Properties.class.equals((Object)type)) {
            node.add((JsonNode)this.processTPropertiesData(form, (Properties)value));
        } else {
            throw new RuntimeException("Do not support type " + type + " yet.");
        }
    }

    private void fillValue(ObjectNode node, Class type, String key, Object value) {
        if (String.class.equals((Object)type)) {
            node.put(key, (String)value);
        } else if (Integer.class.equals((Object)type)) {
            node.put(key, (Integer)value);
        } else if (type.isEnum()) {
            node.put(key, value.toString());
        } else if (Boolean.class.equals((Object)type)) {
            node.put(key, (Boolean)value);
        } else if (Schema.class.equals((Object)type)) {
            node.put(key, value.toString());
        } else if (Double.class.equals((Object)type)) {
            node.put(key, (Double)value);
        } else if (Float.class.equals((Object)type)) {
            node.put(key, (Float)value);
        } else if (Long.class.equals((Object)type)) {
            node.put(key, (Long)value);
        } else if (Date.class.equals((Object)type)) {
            node.put(key, JsonBaseTool.dateFormatter.format((Date)value));
        } else {
            throw new RuntimeException("Do not support type " + type + " yet.");
        }
    }
}

