/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.sandbox.properties;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.StringTokenizer;
import org.talend.daikon.sandbox.properties.StandardPropertiesStrategy;

class SunOracleStandardPropertiesStrategy
implements StandardPropertiesStrategy {
    private static final String SUN_PROPERTIES = "sun.conf";
    private static final String SUN_BOOT_CLASS_PATH = "sun.boot.class.path";
    private static final String JAVA_CLASS_PATH = "java.class.path";

    SunOracleStandardPropertiesStrategy() {
    }

    @Override
    public Properties getStandardProperties() {
        Properties properties = new Properties();
        try {
            InputStream resource = this.getClass().getResourceAsStream(SUN_PROPERTIES);
            if (resource == null) {
                throw new RuntimeException("Expected file 'sun.conf' but wasn't found.");
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(resource));
            String line = bufferedReader.readLine();
            while (line != null) {
                String systemProperty;
                if (!line.startsWith("#") && (systemProperty = System.getProperty(line)) != null) {
                    StringBuilder filteredValue;
                    if (SUN_BOOT_CLASS_PATH.equals(line)) {
                        filteredValue = this.filterJBoss(systemProperty);
                        properties.put(line, filteredValue.toString());
                    } else if (!"java.endorsed.dirs".equals(line)) {
                        if (JAVA_CLASS_PATH.equals(line)) {
                            filteredValue = this.filterJBoss(System.getProperty(SUN_BOOT_CLASS_PATH));
                            properties.put(line, filteredValue.toString());
                        } else {
                            properties.put(line, systemProperty);
                        }
                    }
                }
                line = bufferedReader.readLine();
            }
            return properties;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private StringBuilder filterJBoss(String systemProperty) {
        StringBuilder filteredValue = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(systemProperty, ":");
        while (tokenizer.hasMoreElements()) {
            String current = tokenizer.nextToken();
            if (current.contains("jboss")) continue;
            filteredValue.append(current);
            if (!tokenizer.hasMoreElements()) continue;
            filteredValue.append(':');
        }
        return filteredValue;
    }
}

