/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.runtime;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import org.ops4j.pax.url.mvn.MavenResolver;
import org.ops4j.pax.url.mvn.MavenResolvers;
import org.ops4j.pax.url.mvn.internal.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.daikon.runtime.RuntimeInfo;
import org.talend.daikon.sandbox.SandboxInstanceFactory;
import org.talend.daikon.sandbox.SandboxedInstance;

public class RuntimeUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RuntimeUtil.class);

    public static void registerMavenUrlHandler() {
        try {
            new URL("mvn:foo/bar");
        }
        catch (MalformedURLException e) {
            String mvnLocalRepo = System.getProperty("maven.repo.local");
            if (mvnLocalRepo != null) {
                System.setProperty("org.ops4j.pax.url.mvn.localRepository", mvnLocalRepo);
            }
            RuntimeUtil.registerMavenUrlFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void registerMavenUrlFactory() {
        try {
            Field factoryField = URL.class.getDeclaredField("factory");
            factoryField.setAccessible(true);
            Field lockField = URL.class.getDeclaredField("streamHandlerLock");
            lockField.setAccessible(true);
            Object object = lockField.get(null);
            synchronized (object) {
                URLStreamHandlerFactory factory = (URLStreamHandlerFactory)factoryField.get(null);
                if (factory != null) {
                    return;
                }
                URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory(){

                    @Override
                    public URLStreamHandler createURLStreamHandler(String protocol) {
                        if ("mvn".equals(protocol)) {
                            return new MavenUrlStreamHandler();
                        }
                        return null;
                    }
                });
            }
        }
        catch (Exception exception) {
            LOG.warn(exception.getMessage());
        }
    }

    public static SandboxedInstance createRuntimeClass(RuntimeInfo runtimeInfo, ClassLoader parentClassLoader) {
        return SandboxInstanceFactory.createSandboxedInstance(runtimeInfo, parentClassLoader, false);
    }

    public static SandboxedInstance createRuntimeClassWithCurrentJVMProperties(RuntimeInfo runtimeInfo, ClassLoader parentClassLoader) {
        return SandboxInstanceFactory.createSandboxedInstance(runtimeInfo, parentClassLoader, true);
    }

    static {
        RuntimeUtil.registerMavenUrlHandler();
    }

    public static final class MavenUrlStreamHandler
    extends URLStreamHandler {
        @Override
        public URLConnection openConnection(URL url) throws IOException {
            MavenResolver resolver = MavenResolvers.createMavenResolver(null, (String)"org.ops4j.pax.url.mvn");
            Connection conn = new Connection(url, resolver);
            conn.setUseCaches(false);
            return conn;
        }

        @Override
        protected void parseURL(URL u, String spec, int start, int limit) {
            if (!"mvn:".equals(u.toString())) {
                LOG.debug("ignoring specs for parseUrl with url[" + u + "] and spec[" + spec + "]");
                super.parseURL(u, "", 0, 0);
            } else {
                super.parseURL(u, spec, start, limit);
            }
        }
    }
}

