/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.pattern.word;

import java.util.HashMap;
import java.util.Map;
import org.talend.daikon.pattern.character.CharPatternToRegexConstants;
import org.talend.daikon.pattern.word.WordPatternToRegexConstants;

public enum WordPattern {
    WORD("[Word]", "[\\p{Lu}\\p{Ll}]{2,}", "\\p{Lu}[\\p{Ll}]{1,}"),
    LOWER_WORD("[word]", "[\\p{Lu}\\p{Ll}]{2,}", "[\\p{Ll}]{2,}"),
    UPPER_WORD("[WORD]", "[\\p{Lu}\\p{Ll}]{2,}", "[\\p{Lu}]{2,}"),
    LOWER_CHAR("[char]", "[\\p{Lu}\\p{Ll}]", "[\\p{Ll}]"),
    UPPER_CHAR("[Char]", "[\\p{Lu}\\p{Ll}]", "[\\p{Lu}]"),
    NUMBER("[number]", "[\\p{Nd}]{2,}"),
    DIGIT("[digit]", "[\\p{Nd}]"),
    ALPHANUMERIC("[alnum]", "[\\p{Nd}|\\p{Lu}\\p{Ll}]{2,}"),
    IDEOGRAM("[Ideogram]", "[\\p{script=Han}]"),
    IDEOGRAM_SEQUENCE("[IdeogramSeq]", "[\\p{script=Han}]{2,}"),
    HANGUL("[hangul]", CharPatternToRegexConstants.HANGUL.getRegex()),
    HANGUL_SEQUENCE("[hangulSeq]", CharPatternToRegexConstants.HANGUL.getRegex() + "{2,}"),
    HIRAGANA("[hira]", CharPatternToRegexConstants.HIRAGANA.getRegex()),
    HIRAGANA_SEQUENCE("[hiraSeq]", CharPatternToRegexConstants.HIRAGANA.getRegex() + "{2,}"),
    KATAKANA("[kata]", WordPatternToRegexConstants.KATAKANA),
    KATAKANA_SEQUENCE("[kataSeq]", WordPatternToRegexConstants.KATAKANA + "{2,}");

    private static final Map<String, WordPattern> lookup;
    private final String pattern;
    private final String caseInsensitive;
    private final String caseSensitive;

    public static WordPattern get(String pattern) {
        return lookup.get(pattern);
    }

    private WordPattern(String pattern, String caseInsensitive, String caseSensitive) {
        this.pattern = pattern;
        this.caseInsensitive = caseInsensitive;
        this.caseSensitive = caseSensitive;
    }

    private WordPattern(String pattern, String caseInsensitive) {
        this(pattern, caseInsensitive, caseInsensitive);
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getCaseInsensitive() {
        return this.caseInsensitive;
    }

    public String getCaseSensitive() {
        return this.caseSensitive;
    }

    static {
        lookup = new HashMap<String, WordPattern>();
        for (WordPattern value : WordPattern.values()) {
            lookup.put(value.getPattern(), value);
        }
    }
}

