/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.pattern.character;

import org.talend.daikon.pattern.PatternRegexUtils;
import org.talend.daikon.pattern.character.CharPatternToRegexConstants;

public class CharPatternToRegex {
    private CharPatternToRegex() {
    }

    public static String toRegex(String pattern) {
        return CharPatternToRegex.computeRegex(pattern, false);
    }

    public static String toJavaScriptRegex(String pattern) {
        return CharPatternToRegex.computeRegex(pattern, true);
    }

    private static String computeRegex(String pattern, boolean isForJavaScript) {
        int consecutiveValues;
        StringBuilder stringBuilder = new StringBuilder("^");
        block10: for (int pos = 0; pos < pattern.length(); pos += consecutiveValues) {
            int codePoint = pattern.codePointAt(pos);
            consecutiveValues = CharPatternToRegex.getConsecutiveCodepoints(codePoint, pattern, pos + 1);
            switch (codePoint) {
                case 72: {
                    CharPatternToRegex.buildString(stringBuilder, CharPatternToRegex.getRegex(CharPatternToRegexConstants.HIRAGANA, isForJavaScript), consecutiveValues);
                    continue block10;
                }
                case 107: {
                    CharPatternToRegex.buildString(stringBuilder, CharPatternToRegex.getRegex(CharPatternToRegexConstants.HALFWIDTH_KATAKANA, isForJavaScript), consecutiveValues);
                    continue block10;
                }
                case 75: {
                    CharPatternToRegex.buildString(stringBuilder, CharPatternToRegex.getRegex(CharPatternToRegexConstants.FULLWIDTH_KATAKANA, isForJavaScript), consecutiveValues);
                    continue block10;
                }
                case 67: {
                    String regexC = PatternRegexUtils.buildRegex(CharPatternToRegex.getRegex(CharPatternToRegexConstants.KANJI, isForJavaScript), CharPatternToRegex.getRegex(CharPatternToRegexConstants.KANJI_RARE, isForJavaScript));
                    CharPatternToRegex.buildString(stringBuilder, regexC, consecutiveValues);
                    continue block10;
                }
                case 71: {
                    CharPatternToRegex.buildString(stringBuilder, CharPatternToRegex.getRegex(CharPatternToRegexConstants.HANGUL, isForJavaScript), consecutiveValues);
                    continue block10;
                }
                case 97: {
                    String regexLatin = PatternRegexUtils.buildRegex(CharPatternToRegex.getRegex(CharPatternToRegexConstants.LOWER_LATIN, isForJavaScript), CharPatternToRegex.getRegex(CharPatternToRegexConstants.LOWER_LATIN_RARE, isForJavaScript));
                    String regexa = PatternRegexUtils.buildRegex(regexLatin, CharPatternToRegex.getRegex(CharPatternToRegexConstants.FULLWIDTH_LOWER_LATIN, isForJavaScript));
                    CharPatternToRegex.buildString(stringBuilder, regexa, consecutiveValues);
                    continue block10;
                }
                case 65: {
                    String regexLatinA = PatternRegexUtils.buildRegex(CharPatternToRegex.getRegex(CharPatternToRegexConstants.UPPER_LATIN, isForJavaScript), CharPatternToRegex.getRegex(CharPatternToRegexConstants.UPPER_LATIN_RARE, isForJavaScript));
                    String regexA = PatternRegexUtils.buildRegex(regexLatinA, CharPatternToRegex.getRegex(CharPatternToRegexConstants.FULLWIDTH_UPPER_LATIN, isForJavaScript));
                    CharPatternToRegex.buildString(stringBuilder, regexA, consecutiveValues);
                    continue block10;
                }
                case 57: {
                    String regex9 = PatternRegexUtils.buildRegex(CharPatternToRegex.getRegex(CharPatternToRegexConstants.DIGIT, isForJavaScript), CharPatternToRegex.getRegex(CharPatternToRegexConstants.FULLWIDTH_DIGIT, isForJavaScript));
                    CharPatternToRegex.buildString(stringBuilder, regex9, consecutiveValues);
                    continue block10;
                }
                default: {
                    String notRecognized = PatternRegexUtils.escapeCharacters(String.valueOf(Character.toChars(codePoint)), isForJavaScript);
                    CharPatternToRegex.buildString(stringBuilder, notRecognized, consecutiveValues);
                }
            }
        }
        stringBuilder.append("$");
        return stringBuilder.toString();
    }

    private static String getRegex(CharPatternToRegexConstants patternConstant, boolean isForJavaScript) {
        return isForJavaScript ? patternConstant.getJavaScriptRegex() : patternConstant.getRegex();
    }

    private static void buildString(StringBuilder stringBuilder, String regex, int consecutiveValues) {
        if (consecutiveValues == 1) {
            stringBuilder.append(regex);
        } else {
            stringBuilder.append(regex + "{" + consecutiveValues + "}");
        }
    }

    private static int getConsecutiveCodepoints(int codePoint, String pattern, int currentPos) {
        int lastPos = currentPos;
        while (lastPos < pattern.length() && pattern.codePointAt(lastPos) == codePoint) {
            if (Character.isSurrogate(pattern.charAt(lastPos))) {
                lastPos += 2;
                continue;
            }
            ++lastPos;
        }
        return lastPos - currentPos + 1;
    }
}

