/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.number;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class BigDecimalParser {
    private static final Pattern ENDS_BY_NOT_3_DIGITS_PATTERN = Pattern.compile("^[(-]?\\d+([,.'\\h])(?:\\d{0,2}|\\d{4,})[)]?");
    private static final Pattern STARTS_WITH_DECIMAL_SEPARATOR_PATTERN = Pattern.compile("^[(-]?(?:\\d{3,}|\\d{0})([,.])\\d+[)]?");
    private static final Pattern FEW_GROUP_SEP_PATTERN = Pattern.compile("^[(-]?\\d+([.,\\h'])\\d{3}(\\1\\d{3})+[)]?");
    private static final Pattern TWO_DIFFERENT_SEPARATORS_PATTERN = Pattern.compile(".*\\d+([.\\h'])\\d+([,.])\\d+[)]?");
    private static final Pattern CONTAINS_AT_LEAST_ONE_WHITESPACE = Pattern.compile("^[(-]?\\d+( \\d{3})+[)]?");
    public static final DecimalFormat US_DECIMAL_PATTERN = new DecimalFormat("#,##0.##", DecimalFormatSymbols.getInstance(Locale.US));
    public static final DecimalFormat EU_DECIMAL_PATTERN = new DecimalFormat("#,##0.##", DecimalFormatSymbols.getInstance(Locale.FRENCH));
    public static final DecimalFormat EU_SCIENTIFIC_DECIMAL_PATTERN = new DecimalFormat("0.###E0", DecimalFormatSymbols.getInstance(Locale.FRENCH));
    public static final DecimalFormat US_SCIENTIFIC_DECIMAL_PATTERN = new DecimalFormat("0.###E0", DecimalFormatSymbols.getInstance(Locale.US));
    public static final DecimalFormat EU_PERCENTAGE_DECIMAL_PATTERN = new DecimalFormat("#.##%", DecimalFormatSymbols.getInstance(Locale.FRENCH));
    public static final DecimalFormat US_PERCENTAGE_DECIMAL_PATTERN = new DecimalFormat("#.##%", DecimalFormatSymbols.getInstance(Locale.US));

    private BigDecimalParser() {
    }

    public static BigDecimal toBigDecimal(String from) throws NumberFormatException {
        if (StringUtils.isEmpty((CharSequence)from)) {
            throw new NumberFormatException("null or empty is not a valid number");
        }
        DecimalFormatSymbols decimalFormatSymbols = BigDecimalParser.guessSeparators(from);
        return BigDecimalParser.toBigDecimal(from, decimalFormatSymbols.getDecimalSeparator(), decimalFormatSymbols.getGroupingSeparator());
    }

    public static BigDecimal toBigDecimal(String from, char decimalSeparator, char groupingSeparator) throws NumberFormatException {
        boolean isPercentage;
        if (StringUtils.isEmpty((CharSequence)from)) {
            throw new NumberFormatException("null or empty is not a valid number");
        }
        from = from.replaceAll("[" + groupingSeparator + "]", "");
        from = from.replaceAll("[" + decimalSeparator + "]", ".");
        if ((from = from.replaceAll("\\h", "")).startsWith("(") && from.endsWith(")")) {
            from = "-" + from.substring(1, from.length() - 1);
        }
        if (isPercentage = from.endsWith("%")) {
            from = from.substring(0, from.length() - 1);
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(from);
            return isPercentage ? bigDecimal.movePointLeft(2) : bigDecimal;
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("'" + from + "' can not parsed as a number");
        }
    }

    public static DecimalFormatSymbols guessSeparators(String from) {
        char groupingSeparator;
        char decimalSeparator;
        String firstMatchingGroup;
        DecimalFormatSymbols toReturn = DecimalFormatSymbols.getInstance(Locale.US);
        Matcher matcher = TWO_DIFFERENT_SEPARATORS_PATTERN.matcher(from);
        if (matcher.matches() && matcher.groupCount() >= 2) {
            toReturn.setGroupingSeparator(matcher.group(1).charAt(0));
            toReturn.setDecimalSeparator(matcher.group(2).charAt(0));
        }
        if ((matcher = ENDS_BY_NOT_3_DIGITS_PATTERN.matcher(from)).matches()) {
            firstMatchingGroup = matcher.group(1);
            decimalSeparator = firstMatchingGroup.charAt(0);
            toReturn.setDecimalSeparator(decimalSeparator);
            toReturn.setGroupingSeparator(BigDecimalParser.inferGroupingSeparator(decimalSeparator));
        }
        if ((matcher = STARTS_WITH_DECIMAL_SEPARATOR_PATTERN.matcher(from)).matches()) {
            firstMatchingGroup = matcher.group(1);
            decimalSeparator = firstMatchingGroup.charAt(0);
            toReturn.setDecimalSeparator(decimalSeparator);
            toReturn.setGroupingSeparator(BigDecimalParser.inferGroupingSeparator(decimalSeparator));
        }
        if ((matcher = FEW_GROUP_SEP_PATTERN.matcher(from)).matches()) {
            firstMatchingGroup = matcher.group(1);
            groupingSeparator = firstMatchingGroup.charAt(0);
            toReturn.setGroupingSeparator(groupingSeparator);
            toReturn.setDecimalSeparator(BigDecimalParser.inferDecimalSeparator(groupingSeparator));
        }
        if ((matcher = CONTAINS_AT_LEAST_ONE_WHITESPACE.matcher(from)).matches()) {
            firstMatchingGroup = matcher.group(1);
            groupingSeparator = firstMatchingGroup.charAt(0);
            toReturn.setGroupingSeparator(groupingSeparator);
            toReturn.setDecimalSeparator(BigDecimalParser.inferDecimalSeparator(groupingSeparator));
        }
        return toReturn;
    }

    private static char inferDecimalSeparator(char groupingSeparator) {
        switch (groupingSeparator) {
            case ' ': 
            case '.': {
                return ',';
            }
        }
        return '.';
    }

    private static char inferGroupingSeparator(char decimalSeparator) {
        switch (decimalSeparator) {
            case '.': {
                return ',';
            }
        }
        return '.';
    }

    private static BigDecimal toBigDecimal(Number number) {
        return new BigDecimal(number.toString());
    }

    public static List<DecimalFormat> getSupportedFormats() {
        return Arrays.asList(US_DECIMAL_PATTERN, EU_DECIMAL_PATTERN, EU_PERCENTAGE_DECIMAL_PATTERN, US_PERCENTAGE_DECIMAL_PATTERN, US_SCIENTIFIC_DECIMAL_PATTERN, EU_SCIENTIFIC_DECIMAL_PATTERN);
    }
}

