/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.i18n;

import java.util.MissingResourceException;
import org.talend.daikon.i18n.I18nMessages;
import org.talend.daikon.i18n.LocaleProvider;

public class ClassLoaderBasedI18nMessages
extends I18nMessages {
    private String baseName;
    private String unknownKeyPrefix;
    private transient ClassLoader classLoader;

    public ClassLoaderBasedI18nMessages(LocaleProvider localeProvider, ClassLoader classloader, String baseName, String unknowKeyPrefix) {
        super(localeProvider);
        this.classLoader = classloader;
        this.baseName = baseName;
        this.unknownKeyPrefix = unknowKeyPrefix == null ? "" : unknowKeyPrefix;
    }

    public ClassLoaderBasedI18nMessages(LocaleProvider localeProvider, ClassLoader classloader, String baseName) {
        this(localeProvider, classloader, baseName, null);
    }

    public ClassLoaderBasedI18nMessages(LocaleProvider localeProvider, String baseName, String unknowKeyPrefix) {
        this(localeProvider, I18nMessages.class.getClassLoader(), baseName, unknowKeyPrefix);
    }

    public ClassLoaderBasedI18nMessages(LocaleProvider localeProvider, String baseName) {
        this(localeProvider, baseName, null);
    }

    public ClassLoaderBasedI18nMessages(String baseName, String unknowKeyPrefix) {
        this(null, baseName, unknowKeyPrefix);
    }

    public ClassLoaderBasedI18nMessages(String baseName) {
        this(baseName, null);
    }

    @Override
    public String getMessage(String key, Object ... arguments) {
        try {
            return this.getFormattedMessage(key, this.classLoader, this.baseName, arguments);
        }
        catch (MissingResourceException mre) {
            return this.unknownKeyPrefix + key;
        }
    }

    public I18nMessages createNew(ClassLoader aClassLoader, String aBaseName) {
        return new ClassLoaderBasedI18nMessages(this.localeProvider, aClassLoader, aBaseName);
    }

    public String getBaseName() {
        return this.baseName;
    }
}

