/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.i18n;

import java.util.MissingResourceException;
import org.talend.daikon.i18n.I18nMessages;
import org.talend.daikon.i18n.LocaleProvider;

public class ClassBasedI18nMessages
extends I18nMessages {
    private transient Class<?> clazz;
    private transient String unknownKeyPrefix;

    public ClassBasedI18nMessages(LocaleProvider localeProvider, Class<?> clazz, String unknownKeyPrefix) {
        super(localeProvider);
        this.clazz = clazz;
        this.unknownKeyPrefix = unknownKeyPrefix == null ? "" : unknownKeyPrefix;
    }

    public ClassBasedI18nMessages(LocaleProvider localeProvider, Class<?> clazz) {
        this(localeProvider, clazz, null);
    }

    public ClassBasedI18nMessages(Class<?> clazz, String unknowKeyPrefix) {
        this(null, clazz, unknowKeyPrefix);
    }

    public ClassBasedI18nMessages(Class<?> clazz) {
        this(clazz, null);
    }

    @Override
    public String getMessage(String key, Object ... arguments) {
        for (Class<?> currentClass = this.clazz; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            String baseName = this.computeBaseName(currentClass, true);
            try {
                return this.getFormattedMessage(key, currentClass.getClassLoader(), baseName, arguments);
            }
            catch (MissingResourceException mre) {
                baseName = this.computeBaseName(currentClass, false);
                try {
                    return this.getFormattedMessage(key, currentClass.getClassLoader(), baseName, arguments);
                }
                catch (MissingResourceException mre2) {
                    continue;
                }
            }
        }
        return this.unknownKeyPrefix + key;
    }

    private String computeBaseName(Class<?> currentClass, boolean useClassName) {
        if (useClassName) {
            return currentClass.getName();
        }
        return currentClass.getPackage().getName().concat(".messages");
    }
}

