/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.converter;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import org.talend.daikon.converter.WithFormatConverter;

public class StringConverter
extends WithFormatConverter<StringConverter, String> {
    @Override
    public String convert(Object value) {
        if (value == null) {
            return (String)this.returnDefaultValue();
        }
        if (value instanceof ByteBuffer) {
            return new String(((ByteBuffer)value).array());
        }
        if (this.getNumberFormatter() != null && value instanceof Number) {
            return this.getNumberFormatter().format(value);
        }
        if (this.getDateFormatter() != null) {
            if (value instanceof Number) {
                return LocalDate.ofEpochDay(((Number)value).longValue()).format(this.getDateFormatter());
            }
            if (value instanceof LocalDate) {
                return ((LocalDate)value).format(this.getDateFormatter());
            }
        } else if (this.getTimeMillisFormatter() != null) {
            if (value instanceof Number) {
                return Instant.ofEpochMilli(((Number)value).longValue()).atZone(ZoneOffset.ofTotalSeconds(0)).toLocalTime().format(this.getTimeMillisFormatter());
            }
            if (value instanceof LocalTime) {
                return ((LocalTime)value).format(this.getTimeMillisFormatter());
            }
        } else if (this.getTimestampMillisFormatter() != null) {
            if (value instanceof Number) {
                return Instant.ofEpochMilli(((Number)value).longValue()).atZone(ZoneOffset.ofTotalSeconds(0)).toLocalDateTime().format(this.getTimestampMillisFormatter());
            }
            if (value instanceof LocalDateTime) {
                return ((LocalDateTime)value).format(this.getTimestampMillisFormatter());
            }
        }
        return value.toString();
    }
}

