/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.converter;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.talend.daikon.converter.Converter;
import org.talend.daikon.converter.TypeConverterErrorCode;

public class LocalTimeConverter
extends Converter<LocalTime> {
    public static final String FORMATTER = "formatter";

    @Override
    public LocalTime convert(Object value) {
        if (value == null) {
            return (LocalTime)this.returnDefaultValue();
        }
        if (this.properties.containsKey(FORMATTER)) {
            try {
                return LocalTime.parse(value.toString(), this.getDateTimeFormatter());
            }
            catch (DateTimeParseException dtpe) {
                throw TypeConverterErrorCode.createCannotParseWithFormat(dtpe, value.toString(), this.getDateTimeFormatter().toString());
            }
        }
        return LocalTime.parse(value.toString());
    }

    public LocalTimeConverter withDateTimeFormatter(DateTimeFormatter formatter) {
        this.properties.put(FORMATTER, formatter);
        return this;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return (DateTimeFormatter)this.properties.get(FORMATTER);
    }
}

