/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.converter;

import java.nio.ByteBuffer;
import org.apache.commons.lang3.StringUtils;
import org.talend.daikon.converter.Converter;

public class BooleanConverter
extends Converter<Boolean> {
    @Override
    public Boolean convert(Object value) {
        if (value == null) {
            return (Boolean)this.returnDefaultValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue() != 0.0;
        }
        if (value instanceof CharSequence) {
            if (StringUtils.isBlank((CharSequence)((CharSequence)value))) {
                return (Boolean)this.returnDefaultValue();
            }
            return Boolean.parseBoolean(value.toString());
        }
        if (value instanceof ByteBuffer) {
            ByteBuffer bb = ((ByteBuffer)value).slice();
            return bb.limit() != 0 && bb.get() != 0;
        }
        return Boolean.valueOf(value.toString());
    }
}

