/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.avro.visitor.record;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.talend.daikon.avro.AvroUtils;
import org.talend.daikon.avro.visitor.path.TraversalPath;
import org.talend.daikon.avro.visitor.record.VisitableArray;
import org.talend.daikon.avro.visitor.record.VisitableBoolean;
import org.talend.daikon.avro.visitor.record.VisitableBytes;
import org.talend.daikon.avro.visitor.record.VisitableDouble;
import org.talend.daikon.avro.visitor.record.VisitableFixed;
import org.talend.daikon.avro.visitor.record.VisitableFloat;
import org.talend.daikon.avro.visitor.record.VisitableInt;
import org.talend.daikon.avro.visitor.record.VisitableLong;
import org.talend.daikon.avro.visitor.record.VisitableMap;
import org.talend.daikon.avro.visitor.record.VisitableNull;
import org.talend.daikon.avro.visitor.record.VisitableRecord;
import org.talend.daikon.avro.visitor.record.VisitableString;
import org.talend.daikon.avro.visitor.record.VisitableStructure;

abstract class VisitableStructureFactory {
    private VisitableStructureFactory() {
        throw new UnsupportedOperationException("Cannot be instantiated");
    }

    static VisitableStructure createVisitableField(Schema.Field field, IndexedRecord indexedRecord, TraversalPath path) {
        Schema schema = field.schema();
        Object value = indexedRecord.get(field.pos());
        return VisitableStructureFactory.createVisitableStructure(schema, value, path);
    }

    static VisitableStructure createVisitableStructure(Schema schema, Object value, TraversalPath path) {
        Schema unwrappedSchema = AvroUtils.unwrapIfNullable(schema);
        switch (unwrappedSchema.getType()) {
            case ARRAY: {
                return new VisitableArray(VisitableStructureFactory.ensureArray((List)value, unwrappedSchema), path);
            }
        }
        return VisitableStructureFactory.createWrapperForType(unwrappedSchema.getType(), value, path);
    }

    private static VisitableStructure createWrapperForType(Schema.Type type, Object value, TraversalPath path) {
        switch (type) {
            case INT: {
                return new VisitableInt((Integer)value, path);
            }
            case LONG: {
                return new VisitableLong((Long)value, path);
            }
            case RECORD: {
                return new VisitableRecord((IndexedRecord)value, path);
            }
            case MAP: {
                return new VisitableMap((Map)value, path);
            }
            case STRING: {
                return new VisitableString(value.toString(), path);
            }
            case BOOLEAN: {
                return new VisitableBoolean((Boolean)value, path);
            }
            case FLOAT: {
                return new VisitableFloat((Float)value, path);
            }
            case DOUBLE: {
                return new VisitableDouble((Double)value, path);
            }
            case NULL: {
                return new VisitableNull(path);
            }
            case ENUM: {
                return new VisitableString(value.toString(), path);
            }
            case FIXED: {
                return new VisitableFixed((GenericData.Fixed)value, path);
            }
            case BYTES: {
                return new VisitableBytes((ByteBuffer)value, path);
            }
        }
        throw new IllegalArgumentException("Unsupported Avro data type: " + type);
    }

    private static GenericData.Array ensureArray(List list, Schema schema) {
        if (list instanceof GenericData.Array) {
            return (GenericData.Array)list;
        }
        return new GenericData.Array(schema, (Collection)list);
    }
}

