/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.avro.visitor.record;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.talend.daikon.avro.visitor.path.TraversalPath;
import org.talend.daikon.avro.visitor.record.AbstractVisitableStructure;
import org.talend.daikon.avro.visitor.record.RecordVisitor;
import org.talend.daikon.avro.visitor.record.VisitableStructure;
import org.talend.daikon.avro.visitor.record.VisitableStructureFactory;

public class VisitableArray
extends AbstractVisitableStructure<GenericData.Array> {
    public VisitableArray(GenericData.Array value, TraversalPath path) {
        super(value, path);
    }

    @Override
    public void accept(RecordVisitor visitor) {
        visitor.visit(this);
    }

    public Iterator<VisitableStructure> getItems(ArrayItemsPathType type) {
        GenericData.Array array = (GenericData.Array)this.getValue();
        Schema elementSchema = array.getSchema().getElementType();
        ArrayList<VisitableStructure> items = new ArrayList<VisitableStructure>(array.size());
        for (int i = 0; i < array.size(); ++i) {
            Object value = array.get(i);
            TraversalPath path = type.buildTraversalPath(this.getPath(), i);
            VisitableStructure element = VisitableStructureFactory.createVisitableStructure(elementSchema, value, path);
            items.add(element);
        }
        return Collections.unmodifiableList(items).iterator();
    }

    private static class NotIndexedArrayItemPathBuilder
    implements ArrayItemPathBuilder {
        private NotIndexedArrayItemPathBuilder() {
        }

        @Override
        public TraversalPath buildTraversalPath(TraversalPath path, int index) {
            Schema elementsSchema = path.last().getSchema().getElementType();
            Iterator<TraversalPath.TraversalPathElement> iterator = path.iterator();
            TraversalPath.TraversalPathElement current = iterator.next();
            TraversalPath result = TraversalPath.create(current.getSchema());
            while (current != path.last()) {
                result = result.append(current);
                current = iterator.next();
            }
            result = result.append(path.last().getName(), path.last().getPosition(), elementsSchema);
            return result;
        }
    }

    private static class IndexedArrayItemPathBuilder
    implements ArrayItemPathBuilder {
        private IndexedArrayItemPathBuilder() {
        }

        @Override
        public TraversalPath buildTraversalPath(TraversalPath path, int index) {
            return path.appendArrayIndex(index);
        }
    }

    private static interface ArrayItemPathBuilder {
        public TraversalPath buildTraversalPath(TraversalPath var1, int var2);
    }

    public static enum ArrayItemsPathType {
        INDEXED(new IndexedArrayItemPathBuilder()),
        NOT_INDEXED(new NotIndexedArrayItemPathBuilder());

        private final ArrayItemPathBuilder pathBuilder;

        private ArrayItemsPathType(ArrayItemPathBuilder pathBuilder) {
            this.pathBuilder = pathBuilder;
        }

        private TraversalPath buildTraversalPath(TraversalPath path, int index) {
            return this.pathBuilder.buildTraversalPath(path, index);
        }
    }
}

