/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.avro.inferrer;

import avro.shaded.com.google.common.annotations.VisibleForTesting;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.SchemaNormalization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.daikon.avro.AvroUtils;
import org.talend.daikon.avro.inferrer.SchemaInferrer;
import org.talend.daikon.exception.TalendRuntimeException;

public class JsonSchemaInferrer
implements SchemaInferrer<String> {
    private static final Logger logger = LoggerFactory.getLogger(JsonSchemaInferrer.class);
    private final ObjectMapper mapper;

    public JsonSchemaInferrer(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public static JsonSchemaInferrer createJsonSchemaInferrer() {
        return new JsonSchemaInferrer(new ObjectMapper());
    }

    @Override
    public Schema inferSchema(String json) {
        try {
            JsonNode jsonNode = this.mapper.readTree(json);
            Schema record = Schema.createRecord(this.getFields(jsonNode));
            long fingerprint = SchemaNormalization.parsingFingerprint64((Schema)record);
            return Schema.createRecord((String)("outer_record" + fingerprint).replace('-', '_'), null, (String)"org.talend", (boolean)false, this.getFields(jsonNode));
        }
        catch (IOException | TalendRuntimeException e) {
            throw TalendRuntimeException.createUnexpectedException((Throwable)e.getCause());
        }
    }

    @VisibleForTesting
    List<Schema.Field> getFields(JsonNode jsonNode) {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        Iterator elements = jsonNode.fields();
        block7: while (elements.hasNext()) {
            Map.Entry mapEntry = (Map.Entry)elements.next();
            JsonNode nextNode = (JsonNode)mapEntry.getValue();
            Schema.Field field = null;
            if (!(nextNode instanceof NullNode)) {
                switch (nextNode.getNodeType()) {
                    case NUMBER: {
                        field = new Schema.Field((String)mapEntry.getKey(), this.getAvroSchema(nextNode), null, null, Schema.Field.Order.ASCENDING);
                        fields.add(field);
                        continue block7;
                    }
                    case STRING: {
                        field = new Schema.Field((String)mapEntry.getKey(), AvroUtils.wrapAsNullable(AvroUtils._string()), null, null, Schema.Field.Order.ASCENDING);
                        fields.add(field);
                        continue block7;
                    }
                    case BOOLEAN: {
                        field = new Schema.Field((String)mapEntry.getKey(), AvroUtils.wrapAsNullable(AvroUtils._boolean()), null, null, Schema.Field.Order.ASCENDING);
                        fields.add(field);
                        continue block7;
                    }
                    case ARRAY: {
                        ArrayNode arrayNode = (ArrayNode)nextNode;
                        Iterator nodeIterator = arrayNode.elements();
                        field = nodeIterator.hasNext() ? new Schema.Field((String)mapEntry.getKey(), Schema.createArray((Schema)this.getAvroSchema((JsonNode)nodeIterator.next())), null, null, Schema.Field.Order.ASCENDING) : new Schema.Field((String)mapEntry.getKey(), Schema.createArray((Schema)AvroUtils.wrapAsNullable(AvroUtils._string())), null, null, Schema.Field.Order.ASCENDING);
                        fields.add(field);
                        continue block7;
                    }
                    case OBJECT: {
                        field = new Schema.Field((String)mapEntry.getKey(), this.createSubRecord(nextNode), null, null, Schema.Field.Order.ASCENDING);
                        fields.add(field);
                        continue block7;
                    }
                }
                logger.error("Node type not found - " + nextNode.getNodeType());
                continue;
            }
            field = new Schema.Field((String)mapEntry.getKey(), AvroUtils.wrapAsNullable(AvroUtils._string()), null, null, Schema.Field.Order.ASCENDING);
            fields.add(field);
        }
        return fields;
    }

    @VisibleForTesting
    Schema getAvroSchema(JsonNode node) {
        if (node instanceof TextNode) {
            return AvroUtils.wrapAsNullable(AvroUtils._string());
        }
        if (node instanceof IntNode) {
            return AvroUtils.wrapAsNullable(AvroUtils._int());
        }
        if (node instanceof LongNode) {
            return AvroUtils.wrapAsNullable(AvroUtils._long());
        }
        if (node instanceof DoubleNode) {
            return AvroUtils.wrapAsNullable(AvroUtils._double());
        }
        if (node instanceof BooleanNode) {
            return AvroUtils.wrapAsNullable(AvroUtils._boolean());
        }
        if (node instanceof NullNode) {
            return AvroUtils.wrapAsNullable(AvroUtils._string());
        }
        return this.createSubRecord(node);
    }

    private Schema createSubRecord(JsonNode node) {
        Schema record = Schema.createRecord(this.getFields(node));
        long fingerprint = SchemaNormalization.parsingFingerprint64((Schema)record);
        return Schema.createRecord((String)("subrecord" + fingerprint).replace('-', '_'), null, null, (boolean)false, this.getFields(node));
    }
}

