/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.avro.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.talend.daikon.avro.converter.AvroConverter;
import org.talend.daikon.avro.inferrer.JsonSchemaInferrer;
import org.talend.daikon.exception.TalendRuntimeException;

public class JsonGenericRecordConverter
implements AvroConverter<String, GenericRecord> {
    private JsonSchemaInferrer jsonSchemaInferrer = JsonSchemaInferrer.createJsonSchemaInferrer();
    private Schema schema;

    public JsonGenericRecordConverter() {
    }

    public JsonGenericRecordConverter(Schema schema) {
        this.schema = schema;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public Class<String> getDatumClass() {
        return String.class;
    }

    @Override
    public String convertToDatum(GenericRecord record) {
        return record.toString();
    }

    @Override
    public GenericRecord convertToAvro(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = mapper.readTree(json);
            return this.getOutputRecord(jsonNode, this.schema);
        }
        catch (IOException | TalendRuntimeException e) {
            throw TalendRuntimeException.createUnexpectedException((Throwable)e.getCause());
        }
    }

    private GenericRecord getOutputRecord(JsonNode jsonNode, Schema schema) {
        GenericRecordBuilder outputRecord = new GenericRecordBuilder(schema);
        Iterator elements = jsonNode.fields();
        while (elements.hasNext()) {
            Map.Entry mapEntry = (Map.Entry)elements.next();
            JsonNode nextNode = (JsonNode)mapEntry.getValue();
            if (!(nextNode instanceof NullNode)) {
                if (nextNode instanceof ValueNode) {
                    outputRecord.set((String)mapEntry.getKey(), this.getValue(nextNode));
                    continue;
                }
                if (nextNode instanceof ObjectNode) {
                    Schema schemaTo = this.jsonSchemaInferrer.inferSchema(nextNode.toString());
                    GenericRecord record = this.getOutputRecord(nextNode, schemaTo);
                    outputRecord.set((String)mapEntry.getKey(), (Object)record);
                    continue;
                }
                if (!(nextNode instanceof ArrayNode)) continue;
                ArrayList<Object> listRecords = new ArrayList<Object>();
                Iterator elementsIterator = ((ArrayNode)nextNode).elements();
                while (elementsIterator.hasNext()) {
                    JsonNode nodeTo = (JsonNode)elementsIterator.next();
                    if (nodeTo instanceof ValueNode) {
                        listRecords.add(this.getValue(nodeTo));
                        continue;
                    }
                    Schema schemaTo = this.jsonSchemaInferrer.inferSchema(nodeTo.toString());
                    listRecords.add(this.getOutputRecord(nodeTo, schemaTo));
                }
                outputRecord.set((String)mapEntry.getKey(), listRecords);
                continue;
            }
            outputRecord.set((String)mapEntry.getKey(), null);
        }
        return outputRecord.build();
    }

    private Object getValue(JsonNode node) {
        if (node instanceof TextNode) {
            return node.textValue();
        }
        if (node instanceof IntNode) {
            return node.intValue();
        }
        if (node instanceof LongNode) {
            return node.longValue();
        }
        if (node instanceof DoubleNode) {
            return node.doubleValue();
        }
        if (node instanceof BooleanNode) {
            return node.booleanValue();
        }
        return null;
    }
}

