/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.avro;

import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.talend.daikon.avro.AvroUtils;

public final class LogicalTypeUtils {
    public static final String DATE = "date";
    public static final String TIME_MILLIS = "time-millis";
    public static final String TIME_MICROS = "time-micros";
    public static final String TIMESTAMP_MILLIS = "timestamp-millis";
    public static final String TIMESTAMP_MICROS = "timestamp-micros";

    private LogicalTypeUtils() {
    }

    public static boolean isLogicalTimestampMillis(Schema schema) {
        LogicalType logicalType = schema.getLogicalType();
        return Schema.Type.LONG == schema.getType() && LogicalTypes.timestampMillis().equals(logicalType);
    }

    public static boolean isLogicalTimestampMicros(Schema schema) {
        LogicalType logicalType = schema.getLogicalType();
        return Schema.Type.LONG == schema.getType() && LogicalTypes.timestampMicros().equals(logicalType);
    }

    public static boolean isLogicalDate(Schema schema) {
        LogicalType logicalType = schema.getLogicalType();
        return Schema.Type.INT == schema.getType() && LogicalTypes.date().equals(logicalType);
    }

    public static boolean isLogicalTimeMillis(Schema schema) {
        LogicalType logicalType = schema.getLogicalType();
        return Schema.Type.INT == schema.getType() && LogicalTypes.timeMillis().equals(logicalType);
    }

    public static boolean isLogicalTimeMicros(Schema schema) {
        LogicalType logicalType = schema.getLogicalType();
        return Schema.Type.LONG == schema.getType() && LogicalTypes.timeMicros().equals(logicalType);
    }

    public static String getLogicalTypeName(Schema schema) {
        LogicalType logicalType = schema.getLogicalType();
        if (logicalType == null) {
            return null;
        }
        return logicalType.getName();
    }

    public static Schema getSchemaByLogicalType(String logicalType) {
        if (logicalType == null) {
            return null;
        }
        switch (logicalType) {
            case "date": {
                return AvroUtils._logicalDate();
            }
            case "time-millis": {
                return AvroUtils._logicalTime();
            }
            case "time-micros": {
                return AvroUtils._logicalTimeMicros();
            }
            case "timestamp-millis": {
                return AvroUtils._logicalTimestamp();
            }
            case "timestamp-micros": {
                return AvroUtils._logicalTimestampMicros();
            }
        }
        throw new UnsupportedOperationException("Unrecognized type " + logicalType);
    }
}

