/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.avro;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.talend.daikon.avro.converter.ConvertBigDecimal;
import org.talend.daikon.avro.converter.ConvertByte;
import org.talend.daikon.avro.converter.ConvertCharacter;
import org.talend.daikon.avro.converter.ConvertDate;
import org.talend.daikon.avro.converter.ConvertShort;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.CommonErrorCodes;
import org.talend.daikon.exception.error.ErrorCode;

public class AvroUtils {
    private static final ConvertByte BYTE_TYPE = new ConvertByte();
    private static final ConvertCharacter CHARACTER_TYPE = new ConvertCharacter();
    private static final ConvertDate DATE_TYPE = new ConvertDate();
    private static final ConvertShort SHORT_TYPE = new ConvertShort();
    private static final ConvertBigDecimal DECIMAL_TYPE = new ConvertBigDecimal();
    public static String REJECT_FIELD_INPUT = "input";
    public static String REJECT_FIELD_ERROR_MESSAGE = "errorMessage";

    public static Schema _boolean() {
        return Schema.create((Schema.Type)Schema.Type.BOOLEAN);
    }

    public static Schema _byte() {
        return BYTE_TYPE.getSchema();
    }

    public static Schema _bytes() {
        return Schema.create((Schema.Type)Schema.Type.BYTES);
    }

    public static Schema _character() {
        return CHARACTER_TYPE.getSchema();
    }

    @Deprecated
    public static Schema _date() {
        return DATE_TYPE.getSchema();
    }

    public static Schema _logicalDate() {
        return LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
    }

    public static Schema _logicalTime() {
        return LogicalTypes.timeMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
    }

    public static Schema _logicalTimeMicros() {
        return LogicalTypes.timeMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
    }

    public static Schema _logicalTimestamp() {
        return LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
    }

    public static Schema _logicalTimestampMicros() {
        return LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
    }

    public static Schema _double() {
        return Schema.create((Schema.Type)Schema.Type.DOUBLE);
    }

    public static Schema _float() {
        return Schema.create((Schema.Type)Schema.Type.FLOAT);
    }

    public static Schema _int() {
        return Schema.create((Schema.Type)Schema.Type.INT);
    }

    public static Schema _long() {
        return Schema.create((Schema.Type)Schema.Type.LONG);
    }

    public static Schema _short() {
        return SHORT_TYPE.getSchema();
    }

    public static Schema _string() {
        return Schema.create((Schema.Type)Schema.Type.STRING);
    }

    public static Schema _decimal() {
        return DECIMAL_TYPE.getSchema();
    }

    public static boolean isSameType(Schema actual, Schema expect) {
        String expectJavaClass = expect.getProp("java-class");
        String actualJavaClass = actual.getProp("java-class");
        return actual.getType() == expect.getType() && (actualJavaClass == null ? expectJavaClass == null : actualJavaClass.equals(expectJavaClass));
    }

    public static boolean isNullable(Schema schema) {
        if (schema.getType() == Schema.Type.NULL) {
            return true;
        }
        if (schema.getType() == Schema.Type.UNION) {
            for (Schema unionType : schema.getTypes()) {
                if (unionType.getType() != Schema.Type.NULL) continue;
                return true;
            }
        }
        return false;
    }

    public static Schema wrapAsNullable(Schema schema) {
        if (schema.getType() == Schema.Type.UNION) {
            List unionTypes = schema.getTypes();
            if (unionTypes.contains(Schema.create((Schema.Type)Schema.Type.NULL))) {
                return schema;
            }
            ArrayList<Schema> typesWithNullable = new ArrayList<Schema>(unionTypes);
            typesWithNullable.add(Schema.create((Schema.Type)Schema.Type.NULL));
            return Schema.createUnion(typesWithNullable);
        }
        return (Schema)SchemaBuilder.nullable().type(schema);
    }

    public static Schema unwrapIfNullable(Schema schema) {
        if (schema.getType() == Schema.Type.UNION) {
            List unionTypes = schema.getTypes();
            if (unionTypes.size() == 2) {
                if (((Schema)unionTypes.get(0)).getType().equals((Object)Schema.Type.NULL)) {
                    return (Schema)unionTypes.get(1);
                }
                if (((Schema)unionTypes.get(1)).getType().equals((Object)Schema.Type.NULL)) {
                    return (Schema)unionTypes.get(0);
                }
            } else if (unionTypes.contains(Schema.create((Schema.Type)Schema.Type.NULL))) {
                ArrayList typesWithoutNullable = new ArrayList(unionTypes);
                typesWithoutNullable.remove(Schema.create((Schema.Type)Schema.Type.NULL));
                return Schema.createUnion(typesWithoutNullable);
            }
        }
        return schema;
    }

    public static Map<String, Schema.Field> makeFieldMap(Schema schema) {
        HashMap<String, Schema.Field> map = new HashMap<String, Schema.Field>();
        for (Schema.Field field : schema.getFields()) {
            map.put(field.name(), field);
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Schema setProperty(Schema schema, String key, String value) {
        Schema newSchema = schema;
        if (schema.getProp(key) != null) {
            if (schema.getType() != Schema.Type.RECORD) throw new RuntimeException("Not support this type " + newSchema.getType() + " now, need to implement");
            newSchema = Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)schema.isError());
            ArrayList<Schema.Field> copyFieldList = new ArrayList<Schema.Field>();
            for (Schema.Field se : schema.getFields()) {
                copyFieldList.add(new Schema.Field(se.name(), se.schema(), se.doc(), se.defaultVal()));
            }
            newSchema.setFields(copyFieldList);
            Map props = schema.getObjectProps();
            for (String propKey : props.keySet()) {
                if (propKey.equals(key)) {
                    newSchema.addProp(key, value);
                    continue;
                }
                newSchema.addProp(propKey, props.get(propKey));
            }
            return newSchema;
        } else {
            schema.addProp(key, value);
        }
        return newSchema;
    }

    public static Schema appendFields(Schema schema, Schema.Field ... fields) {
        Schema newSchema = schema;
        if (schema.getType() == Schema.Type.RECORD) {
            newSchema = Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)schema.isError());
            ArrayList<Schema.Field> copyFieldList = new ArrayList<Schema.Field>();
            for (Schema.Field se : schema.getFields()) {
                copyFieldList.add(new Schema.Field(se.name(), se.schema(), se.doc(), se.defaultVal()));
            }
            for (Schema.Field field : fields) {
                copyFieldList.add(field);
            }
            newSchema.setFields(copyFieldList);
            Map props = schema.getObjectProps();
            for (String propKey : props.keySet()) {
                newSchema.addProp(propKey, props.get(propKey));
            }
        } else {
            TalendRuntimeException.build((ErrorCode)CommonErrorCodes.UNEXPECTED_EXCEPTION).setAndThrow(new String[]{"Not support this type " + schema.getType() + ", only support record type"});
        }
        return newSchema;
    }

    public static Schema removeFields(Schema schema, Set<String> fieldNames) {
        Schema newSchema = schema;
        if (schema.getType() == Schema.Type.RECORD) {
            newSchema = Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)schema.isError());
            ArrayList<Schema.Field> copyFieldList = new ArrayList<Schema.Field>();
            for (Schema.Field se : schema.getFields()) {
                if (fieldNames.contains(se.name())) continue;
                copyFieldList.add(new Schema.Field(se.name(), se.schema(), se.doc(), se.defaultVal()));
            }
            newSchema.setFields(copyFieldList);
            Map props = schema.getObjectProps();
            for (String propKey : props.keySet()) {
                newSchema.addProp(propKey, props.get(propKey));
            }
        } else {
            TalendRuntimeException.build((ErrorCode)CommonErrorCodes.UNEXPECTED_EXCEPTION).setAndThrow(new String[]{"Not support this type " + schema.getType() + ", only support record type"});
        }
        return newSchema;
    }

    public static boolean isIncludeAllFields(Schema schema) {
        String prop = schema.getProp("include-all-fields");
        return prop != null && Boolean.valueOf(prop) != false;
    }

    public static Schema setIncludeAllFields(Schema schema, boolean value) {
        return AvroUtils.setProperty(schema, "include-all-fields", String.valueOf(value));
    }

    public static boolean isSchemaEmpty(Schema schema) {
        if (schema == null) {
            return true;
        }
        if (AvroUtils.isIncludeAllFields(schema)) {
            return false;
        }
        List fields = schema.getFields();
        return fields == null || fields.isEmpty();
    }

    public static Schema createEmptySchema() {
        Schema emptySchema = (Schema)SchemaBuilder.builder().record("EmptySchema").fields().endRecord();
        return emptySchema;
    }

    public static List<String> getFieldNames(Schema schema) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Schema.Field f : schema.getFields()) {
            fieldNames.add(f.name());
        }
        return fieldNames;
    }

    public static Schema createRejectSchema(Schema originalSchema, String rejectSchemaName) {
        Schema newSchema = Schema.createRecord((String)rejectSchemaName, (String)originalSchema.getDoc(), (String)originalSchema.getNamespace(), (boolean)originalSchema.isError());
        Schema.Field inputField = new Schema.Field(REJECT_FIELD_INPUT, originalSchema, null, null);
        Schema.Field errorMessageField = new Schema.Field(REJECT_FIELD_ERROR_MESSAGE, Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        newSchema.setFields(Arrays.asList(inputField, errorMessageField));
        for (Map.Entry entry : originalSchema.getObjectProps().entrySet()) {
            newSchema.addProp((String)entry.getKey(), entry.getValue());
        }
        return newSchema;
    }

    public static boolean isString(Schema.Type type) {
        return Schema.Type.STRING.equals((Object)type);
    }

    public static boolean isNumerical(Schema.Type type) {
        return Schema.Type.INT.equals((Object)type) || Schema.Type.LONG.equals((Object)type) || Schema.Type.DOUBLE.equals((Object)type) || Schema.Type.FLOAT.equals((Object)type);
    }
}

