/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.avro;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class AvroNamesValidationHelper {
    private static final Set<String> JAVA_KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "true", "false", "null"));
    private static final Pattern CONTEXT_AND_VARIABLE_PATTERN = Pattern.compile("^[a-zA-Z_][a-zA-Z_0-9]*$");

    public static String getAvroCompatibleName(String name) {
        if (AvroNamesValidationHelper.isValidParameterName(name)) {
            return name;
        }
        return "_" + name;
    }

    public static boolean isValidParameterName(String name) {
        if (name == null || AvroNamesValidationHelper.isJavaKeyWord(name)) {
            return false;
        }
        return CONTEXT_AND_VARIABLE_PATTERN.matcher(name).matches();
    }

    public static boolean isJavaKeyWord(String name) {
        return JAVA_KEYWORDS.contains(name);
    }
}

